/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.net.port_locking;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.terracotta.angela.common.net.port_locking.PortLock;
import org.terracotta.angela.common.net.port_locking.PortLockingException;

public class MuxPortLock
implements PortLock {
    private final int port;
    private final List<PortLock> portLocks;

    MuxPortLock(int port) {
        this.port = port;
        this.portLocks = new ArrayList<PortLock>();
    }

    private MuxPortLock(int port, List<PortLock> portLocks1, List<PortLock> portLocks2) {
        this.port = port;
        this.portLocks = new ArrayList<PortLock>(portLocks1.size() + portLocks2.size());
        this.portLocks.addAll(portLocks1);
        this.portLocks.addAll(portLocks2);
    }

    void addPortLock(PortLock portLock) {
        this.portLocks.add(portLock);
    }

    public MuxPortLock combine(MuxPortLock other) {
        return new MuxPortLock(this.port, this.portLocks, other.portLocks);
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void close() {
        PortLockingException closeError = new PortLockingException("Error closing MuxPortLock");
        Collections.reverse(this.portLocks);
        this.portLocks.forEach(portLock -> {
            try {
                portLock.close();
            }
            catch (PortLockingException e) {
                closeError.addSuppressed(e);
            }
        });
        this.portLocks.clear();
        if (closeError.getSuppressed().length > 0) {
            throw closeError;
        }
    }
}

