/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.net.port_locking;

import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import org.terracotta.angela.common.net.port_locking.EmptyPortLock;
import org.terracotta.angela.common.net.port_locking.PortLock;
import org.terracotta.angela.common.net.port_locking.PortLocker;
import org.terracotta.angela.common.net.port_locking.PortLockingException;

public class SocketPortLocker
implements PortLocker {
    @Override
    public PortLock tryLockPort(int port) {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(port);
            EmptyPortLock emptyPortLock = new EmptyPortLock(port);
            return emptyPortLock;
        }
        catch (BindException be) {
            PortLock portLock = null;
            return portLock;
        }
        catch (IOException e) {
            throw new PortLockingException("Error detecting whether port " + port + " is available to bind", e);
        }
        finally {
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (IOException e) {
                    throw new PortLockingException("Failed to close socket", e);
                }
            }
        }
    }
}

