/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.provider;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.terracotta.angela.common.dynamic_cluster.Stripe;
import org.terracotta.angela.common.net.DisruptionProvider;
import org.terracotta.angela.common.net.Disruptor;
import org.terracotta.angela.common.net.PortAllocator;
import org.terracotta.angela.common.provider.ConfigurationManager;
import org.terracotta.angela.common.tcconfig.ServerSymbolicName;
import org.terracotta.angela.common.tcconfig.TerracottaServer;

public class DynamicConfigManager
implements ConfigurationManager {
    private final List<Stripe> stripes;

    private DynamicConfigManager(Stripe ... stripes) {
        if (stripes == null || stripes.length == 0) {
            throw new IllegalArgumentException("Stripe list cannot be null or empty");
        }
        this.stripes = new ArrayList<Stripe>(Arrays.asList(stripes));
    }

    public static DynamicConfigManager dynamicCluster(Stripe ... stripes) {
        return new DynamicConfigManager(stripes);
    }

    @Override
    public int getStripeIndexOf(UUID serverId) {
        for (int i = 0; i < this.stripes.size(); ++i) {
            for (TerracottaServer server : this.stripes.get(i).getServers()) {
                if (!server.getId().equals(serverId)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public void addStripe(TerracottaServer ... newServers) {
        this.stripes.add(Stripe.stripe(newServers));
    }

    @Override
    public void removeStripe(int stripeIndex) {
        if (stripeIndex >= this.stripes.size()) {
            throw new IllegalArgumentException("No such stripe #" + stripeIndex + " (there are: " + this.stripes.size() + ")");
        }
        this.stripes.remove(stripeIndex);
    }

    @Override
    public List<List<TerracottaServer>> getStripes() {
        ArrayList<List<TerracottaServer>> stripeList = new ArrayList<List<TerracottaServer>>();
        for (Stripe stripe : this.stripes) {
            stripeList.add(new ArrayList<TerracottaServer>(stripe.getServers()));
        }
        return stripeList;
    }

    @Override
    public void addServer(int stripeIndex, TerracottaServer newServer) {
        if (stripeIndex >= this.stripes.size()) {
            throw new IllegalArgumentException("No such stripe #" + stripeIndex + " (there are: " + this.stripes.size() + ")");
        }
        this.stripes.get(stripeIndex).addServer(newServer);
    }

    @Override
    public void removeServer(int stripeIndex, int serverIndex) {
        if (stripeIndex >= this.stripes.size()) {
            throw new IllegalArgumentException("No such stripe #" + stripeIndex + " (there are: " + this.stripes.size() + ")");
        }
        List<TerracottaServer> servers = this.stripes.get(stripeIndex).getServers();
        if (serverIndex >= servers.size()) {
            throw new IllegalArgumentException("No such server #" + serverIndex + " (there are: " + servers.size() + " in stripe " + stripeIndex + ")");
        }
        Stripe stripe = this.stripes.get(stripeIndex);
        stripe.removeServer(serverIndex);
        if (stripe.getServers().size() == 0) {
            this.stripes.remove(stripeIndex);
        }
    }

    @Override
    public TerracottaServer getServer(int stripeIndex, int serverIndex) {
        if (stripeIndex >= this.stripes.size()) {
            throw new IllegalArgumentException("No such stripe #" + stripeIndex + " (there are: " + this.stripes.size() + ")");
        }
        List<TerracottaServer> servers = this.stripes.get(stripeIndex).getServers();
        if (serverIndex >= servers.size()) {
            throw new IllegalArgumentException("No such server #" + serverIndex + " (there are: " + servers.size() + " in stripe " + stripeIndex + ")");
        }
        return servers.get(serverIndex);
    }

    @Override
    public TerracottaServer getServer(UUID serverId) {
        for (Stripe stripe : this.stripes) {
            for (TerracottaServer terracottaServer : stripe.getServers()) {
                if (!terracottaServer.getId().equals(serverId)) continue;
                return terracottaServer;
            }
        }
        return null;
    }

    @Override
    public List<TerracottaServer> getServers() {
        ArrayList<TerracottaServer> servers = new ArrayList<TerracottaServer>();
        for (Stripe stripe : this.stripes) {
            servers.addAll(stripe.getServers());
        }
        return servers;
    }

    @Override
    public Collection<String> getServersHostnames() {
        ArrayList<String> hostnames = new ArrayList<String>();
        for (Stripe stripe : this.stripes) {
            for (TerracottaServer terracottaServer : stripe.getServers()) {
                hostnames.add(terracottaServer.getHostname());
            }
        }
        return hostnames;
    }

    @Override
    public void createDisruptionLinks(TerracottaServer terracottaServer, DisruptionProvider disruptionProvider, Map<ServerSymbolicName, Disruptor> disruptionLinks, Map<ServerSymbolicName, Integer> proxiedPorts, PortAllocator portAllocator) {
        int stripeIndex = this.getStripeIndexOf(terracottaServer.getId());
        List<TerracottaServer> allServersInStripe = this.stripes.get(stripeIndex).getServers();
        for (TerracottaServer server : allServersInStripe) {
            if (server.getServerSymbolicName().equals(terracottaServer.getServerSymbolicName())) continue;
            int tsaRandomGroupPort = portAllocator.getNewRandomFreePort().getBasePort();
            InetSocketAddress src = new InetSocketAddress(terracottaServer.getHostname(), tsaRandomGroupPort);
            InetSocketAddress dest = new InetSocketAddress(server.getHostname(), server.getTsaGroupPort());
            disruptionLinks.put(server.getServerSymbolicName(), disruptionProvider.createLink(src, dest));
            proxiedPorts.put(server.getServerSymbolicName(), src.getPort());
        }
    }
}

