/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.distribution;

import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.common.ClusterToolExecutionResult;
import org.terracotta.angela.common.ConfigToolExecutionResult;
import org.terracotta.angela.common.TerracottaCommandLineEnvironment;
import org.terracotta.angela.common.TerracottaManagementServerInstance;
import org.terracotta.angela.common.TerracottaServerInstance;
import org.terracotta.angela.common.TerracottaServerState;
import org.terracotta.angela.common.TerracottaVoter;
import org.terracotta.angela.common.TerracottaVoterInstance;
import org.terracotta.angela.common.ToolExecutionResult;
import org.terracotta.angela.common.distribution.Distribution;
import org.terracotta.angela.common.tcconfig.SecurityRootDirectory;
import org.terracotta.angela.common.tcconfig.ServerSymbolicName;
import org.terracotta.angela.common.tcconfig.TerracottaServer;
import org.terracotta.angela.common.topology.Topology;
import org.terracotta.angela.common.util.JavaLocationResolver;
import org.terracotta.angela.common.util.OS;
import org.terracotta.angela.common.util.ProcessUtil;
import org.terracotta.angela.common.util.RetryUtils;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.ProcessResult;

public abstract class DistributionController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DistributionController.class);
    protected final Distribution distribution;
    protected final JavaLocationResolver javaLocationResolver = new JavaLocationResolver();

    DistributionController(Distribution distribution) {
        this.distribution = distribution;
    }

    protected Map<String, String> buildEnv(TerracottaCommandLineEnvironment tcEnv) {
        HashMap<String, String> env = new HashMap<String, String>();
        String javaHome = tcEnv.getJavaHome().orElseGet(() -> this.javaLocationResolver.resolveJavaLocation(tcEnv).getHome());
        env.put("JAVA_HOME", javaHome);
        LOGGER.info(" JAVA_HOME = {}", (Object)javaHome);
        Set<String> javaOpts = tcEnv.getJavaOpts();
        if (!javaOpts.isEmpty()) {
            String joinedJavaOpts = String.join((CharSequence)" ", javaOpts);
            env.put("JAVA_OPTS", joinedJavaOpts);
            LOGGER.info(" JAVA_OPTS = {}", (Object)joinedJavaOpts);
        }
        return env;
    }

    public ToolExecutionResult invokeJcmd(TerracottaServerInstance.TerracottaServerInstanceProcess terracottaServerInstanceProcess, TerracottaCommandLineEnvironment tcEnv, String ... arguments) {
        Number javaPid = terracottaServerInstanceProcess.getJavaPid();
        if (javaPid == null) {
            return new ToolExecutionResult(-1, Collections.singletonList("PID of java process could not be figured out"));
        }
        String javaHome = tcEnv.getJavaHome().orElseGet(() -> this.javaLocationResolver.resolveJavaLocation(tcEnv).getHome());
        ArrayList<String> cmdLine = new ArrayList<String>();
        if (OS.INSTANCE.isWindows()) {
            cmdLine.add(javaHome + "\\bin\\jcmd.exe");
        } else {
            cmdLine.add(javaHome + "/bin/jcmd");
        }
        cmdLine.add(javaPid.toString());
        cmdLine.addAll(Arrays.asList(arguments));
        try {
            ProcessResult processResult = new ProcessExecutor(cmdLine).redirectErrorStream(true).readOutput(true).execute();
            return new ToolExecutionResult(processResult.getExitValue(), processResult.getOutput().getLines());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public abstract TerracottaServerInstance.TerracottaServerInstanceProcess createTsa(TerracottaServer var1, File var2, File var3, Topology var4, Map<ServerSymbolicName, Integer> var5, TerracottaCommandLineEnvironment var6, List<String> var7);

    public abstract TerracottaManagementServerInstance.TerracottaManagementServerInstanceProcess startTms(File var1, File var2, TerracottaCommandLineEnvironment var3);

    public abstract void stopTms(File var1, TerracottaManagementServerInstance.TerracottaManagementServerInstanceProcess var2, TerracottaCommandLineEnvironment var3);

    public void stopTsa(ServerSymbolicName serverSymbolicName, TerracottaServerInstance.TerracottaServerInstanceProcess terracottaServerInstanceProcess) {
        LOGGER.debug("Destroying TC server process for {}", (Object)serverSymbolicName);
        for (Number pid : terracottaServerInstanceProcess.getPids()) {
            try {
                ProcessUtil.destroyGracefullyOrForcefullyAndWait(pid.intValue());
            }
            catch (Exception e) {
                throw new RuntimeException("Could not destroy TC server process with PID " + pid, e);
            }
        }
        int maxWaitTimeMillis = 30000;
        if (!RetryUtils.waitFor(() -> terracottaServerInstanceProcess.getState() == TerracottaServerState.STOPPED, 30000L)) {
            throw new RuntimeException(String.format("Tried for %dms, but server %s did not get the state %s [remained at state %s]", new Object[]{30000, serverSymbolicName.getSymbolicName(), TerracottaServerState.STOPPED, terracottaServerInstanceProcess.getState()}));
        }
    }

    public abstract TerracottaVoterInstance.TerracottaVoterInstanceProcess startVoter(TerracottaVoter var1, File var2, File var3, TerracottaCommandLineEnvironment var4);

    public abstract void stopVoter(TerracottaVoterInstance.TerracottaVoterInstanceProcess var1);

    public abstract void configure(String var1, File var2, File var3, String var4, Topology var5, Map<ServerSymbolicName, Integer> var6, SecurityRootDirectory var7, TerracottaCommandLineEnvironment var8, boolean var9);

    public abstract ClusterToolExecutionResult invokeClusterTool(File var1, File var2, TerracottaCommandLineEnvironment var3, String ... var4);

    public abstract ConfigToolExecutionResult invokeConfigTool(File var1, File var2, TerracottaCommandLineEnvironment var3, Path var4, String ... var5);

    public abstract URI tsaUri(Collection<TerracottaServer> var1, Map<ServerSymbolicName, Integer> var2);

    public abstract String clientJarsRootFolderName(Distribution var1);

    public abstract String pluginJarsRootFolderName(Distribution var1);

    public abstract String terracottaInstallationRoot();
}

