/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.terracotta.angela.common.AngelaProperties;

public class TerracottaCommandLineEnvironment {
    public static final TerracottaCommandLineEnvironment DEFAULT;
    private final Optional<String> javaHome;
    private final String javaVersion;
    private final Set<String> javaVendors;
    private final Set<String> javaOpts;

    private TerracottaCommandLineEnvironment(Optional<String> javaHome, String javaVersion, Set<String> javaVendors, Set<String> javaOpts) {
        TerracottaCommandLineEnvironment.validate(javaVersion, javaVendors, javaOpts);
        this.javaHome = javaHome;
        this.javaVersion = javaVersion;
        this.javaVendors = Collections.unmodifiableSet(new LinkedHashSet<String>(javaVendors));
        this.javaOpts = Collections.unmodifiableSet(new LinkedHashSet<String>(javaOpts));
    }

    private static void validate(String javaVersion, Set<String> javaVendors, Set<String> javaOpts) {
        Objects.requireNonNull(javaVersion);
        Objects.requireNonNull(javaVendors);
        Objects.requireNonNull(javaOpts);
        if (javaVendors.stream().anyMatch(vendor -> vendor == null || vendor.isEmpty())) {
            throw new IllegalArgumentException("None of the java vendors can be null or empty");
        }
        if (javaOpts.stream().anyMatch(opt -> opt == null || opt.isEmpty())) {
            throw new IllegalArgumentException("None of the java opts can be null or empty");
        }
    }

    public TerracottaCommandLineEnvironment withJavaVersion(String javaVersion) {
        return new TerracottaCommandLineEnvironment(this.javaHome, javaVersion, this.javaVendors, this.javaOpts);
    }

    public TerracottaCommandLineEnvironment withJavaVendors(String ... javaVendors) {
        return new TerracottaCommandLineEnvironment(this.javaHome, this.javaVersion, new LinkedHashSet<String>(Arrays.asList(javaVendors)), this.javaOpts);
    }

    public TerracottaCommandLineEnvironment withJavaOpts(String ... javaOpts) {
        return new TerracottaCommandLineEnvironment(this.javaHome, this.javaVersion, this.javaVendors, new LinkedHashSet<String>(Arrays.asList(javaOpts)));
    }

    public TerracottaCommandLineEnvironment withJavaHome(String jdkHome) {
        return new TerracottaCommandLineEnvironment(Optional.of(jdkHome), this.javaVersion, this.javaVendors, this.javaOpts);
    }

    public Optional<String> getJavaHome() {
        return this.javaHome;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public Set<String> getJavaVendors() {
        return this.javaVendors;
    }

    public Set<String> getJavaOpts() {
        return this.javaOpts;
    }

    public String toString() {
        return "TerracottaCommandLineEnvironment{javaVersion='" + this.javaVersion + '\'' + ", javaVendors=" + this.javaVendors + ", javaOpts=" + this.javaOpts + '}';
    }

    static {
        String version = AngelaProperties.JAVA_VERSION.getValue();
        LinkedHashSet<String> vendors = AngelaProperties.JAVA_VENDOR.getValue().equals("") ? new LinkedHashSet() : Collections.singleton(AngelaProperties.JAVA_VENDOR.getValue());
        LinkedHashSet<String> opts = AngelaProperties.JAVA_OPTS.getValue().equals("") ? new LinkedHashSet() : Collections.singleton(AngelaProperties.JAVA_OPTS.getValue());
        DEFAULT = new TerracottaCommandLineEnvironment(Optional.empty(), version, vendors, opts);
    }
}

