/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.util;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.stream.Stream;

public class FileUtils {
    public static void setCorrectPermissions(Path dest) {
        if (!FileSystems.getDefault().supportedFileAttributeViews().contains("posix")) {
            return;
        }
        try (Stream<Path> walk = Files.walk(dest, new FileVisitOption[0]);){
            walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> {
                String name = path.getFileName().toString();
                return name.endsWith(".sh") || name.endsWith("tms.jar");
            }).forEach(path -> {
                try {
                    HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>(Files.getPosixFilePermissions(path, new LinkOption[0]));
                    perms.addAll(EnumSet.of(PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_EXECUTE));
                    Files.setPosixFilePermissions(path, perms);
                }
                catch (IOException ioe) {
                    throw new UncheckedIOException(ioe);
                }
            });
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    public static void createAndValidateDir(Path dirToCreate) {
        try {
            if (!Files.exists(dirToCreate, new LinkOption[0])) {
                Files.createDirectories(dirToCreate, new FileAttribute[0]);
            } else if (!Files.isDirectory(dirToCreate, new LinkOption[0])) {
                throw new RuntimeException(dirToCreate.getFileName() + " is not a directory");
            }
            if (!Files.isWritable(dirToCreate)) {
                throw new RuntimeException(dirToCreate.getFileName() + " directory is not writable");
            }
            if (FileSystems.getDefault().supportedFileAttributeViews().contains("posix")) {
                HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>(Files.getPosixFilePermissions(dirToCreate, new LinkOption[0]));
                perms.addAll(EnumSet.of(PosixFilePermission.OWNER_WRITE, PosixFilePermission.GROUP_WRITE, PosixFilePermission.OTHERS_WRITE));
                Files.setPosixFilePermissions(dirToCreate, perms);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static boolean deleteQuietly(Path path) {
        try {
            FileUtils.deleteTree(path);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void copy(Path src, Path dest, CopyOption ... copyOptions) {
        try {
            org.terracotta.utilities.io.Files.copy((Path)src, (Path)dest, (CopyOption[])copyOptions);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void deleteTree(Path file) {
        try {
            org.terracotta.utilities.io.Files.deleteTree((Path)file);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

