/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.distribution;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.StartedProcess;
import org.zeroturnaround.process.PidUtil;

class WatchedProcess<S extends Enum<S>> {
    private final StartedProcess startedProcess;
    private final int pid;

    public WatchedProcess(ProcessExecutor processExecutor, AtomicReference<S> stateRef, S deadState) {
        try {
            this.startedProcess = processExecutor.start();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot start process " + processExecutor.getCommand(), e);
        }
        this.pid = PidUtil.getPid((Process)this.startedProcess.getProcess());
        Thread watcherThread = new Thread(() -> {
            try {
                this.startedProcess.getFuture().get();
                stateRef.set(deadState);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        });
        watcherThread.setDaemon(true);
        watcherThread.setName("ProcessWatcher on PID#" + this.pid);
        watcherThread.start();
    }

    public boolean isAlive() {
        return this.startedProcess.getProcess().isAlive();
    }

    public int getPid() {
        return this.pid;
    }
}

