/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.terracotta.angela.common.TerracottaCommandLineEnvironment;
import org.terracotta.angela.common.TerracottaManagementServerState;
import org.terracotta.angela.common.distribution.DistributionController;

public class TerracottaManagementServerInstance {
    private final DistributionController distributionController;
    private final File kitDir;
    private final File workingDir;
    private final TerracottaCommandLineEnvironment tcEnv;
    private volatile TerracottaManagementServerInstanceProcess terracottaManagementServerInstanceProcess = new TerracottaManagementServerInstanceProcess(new AtomicReference<TerracottaManagementServerState>(TerracottaManagementServerState.STOPPED), new Number[0]);

    public TerracottaManagementServerInstance(DistributionController distributionController, File kitDir, File workingDir, TerracottaCommandLineEnvironment tcEnv) {
        this.distributionController = distributionController;
        this.kitDir = kitDir;
        this.workingDir = workingDir;
        this.tcEnv = tcEnv;
    }

    public void start(Map<String, String> envOverrides) {
        this.terracottaManagementServerInstanceProcess = this.distributionController.startTms(this.kitDir, this.workingDir, this.tcEnv, envOverrides);
    }

    public void stop() {
        this.distributionController.stopTms(this.kitDir, this.terracottaManagementServerInstanceProcess, this.tcEnv);
    }

    public TerracottaManagementServerState getTerracottaManagementServerState() {
        return this.terracottaManagementServerInstanceProcess.getState();
    }

    public static class TerracottaManagementServerInstanceProcess {
        private final Set<Number> pids;
        private final AtomicReference<TerracottaManagementServerState> state;

        public TerracottaManagementServerInstanceProcess(AtomicReference<TerracottaManagementServerState> state, Number ... pids) {
            for (Number pid : pids) {
                if (pid.intValue() >= 1) continue;
                throw new IllegalArgumentException("Pid cannot be < 1");
            }
            this.pids = new HashSet<Number>(Arrays.asList(pids));
            this.state = state;
        }

        public TerracottaManagementServerState getState() {
            return this.state.get();
        }

        public Set<Number> getPids() {
            return Collections.unmodifiableSet(this.pids);
        }
    }
}

