/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.util;

import java.util.function.Consumer;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.terracotta.angela.common.util.LogOutputStream;

public class TriggeringOutputStream
extends LogOutputStream {
    private final Consumer<String> consumer;

    public static final TriggeringOutputStream triggerOn(Pattern pattern, Consumer<MatchResult> action) {
        return new TriggeringOutputStream(line -> {
            Matcher matcher = pattern.matcher((CharSequence)line);
            if (matcher.matches()) {
                action.accept(matcher.toMatchResult());
            }
        });
    }

    public final TriggeringOutputStream andTriggerOn(Pattern pattern, Consumer<MatchResult> action) {
        return new TriggeringOutputStream(line -> {
            try {
                this.consumer.accept((String)line);
            }
            finally {
                Matcher matcher = pattern.matcher((CharSequence)line);
                if (matcher.matches()) {
                    action.accept(matcher.toMatchResult());
                }
            }
        });
    }

    public final TriggeringOutputStream andForward(Consumer<String> action) {
        return new TriggeringOutputStream(line -> {
            try {
                this.consumer.accept((String)line);
            }
            finally {
                action.accept((String)line);
            }
        });
    }

    private TriggeringOutputStream(Consumer<String> consumer) {
        this.consumer = consumer;
    }

    @Override
    protected void processLine(String line) {
        this.consumer.accept(line);
    }
}

