/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.distribution;

import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.common.TerracottaCommandLineEnvironment;
import org.terracotta.angela.common.TerracottaServerHandle;
import org.terracotta.angela.common.TerracottaServerState;
import org.terracotta.angela.common.distribution.Distribution;
import org.terracotta.angela.common.distribution.Distribution107Controller;
import org.terracotta.angela.common.distribution.IsolatedClassLoader;
import org.terracotta.angela.common.tcconfig.ServerSymbolicName;
import org.terracotta.angela.common.tcconfig.TerracottaServer;
import org.terracotta.angela.common.topology.Topology;

public class Distribution107InlineController
extends Distribution107Controller {
    private static final Logger LOGGER = LoggerFactory.getLogger(Distribution107InlineController.class);

    public Distribution107InlineController(Distribution distribution) {
        super(distribution);
    }

    @Override
    public TerracottaServerHandle createTsa(TerracottaServer terracottaServer, File kitDir, File workingDir, Topology topology, Map<ServerSymbolicName, Integer> proxiedPorts, TerracottaCommandLineEnvironment tcEnv, Map<String, String> envOverrides, List<String> startUpArgs, Duration inactivityKillerDelay) {
        List<String> options = startUpArgs != null && !startUpArgs.isEmpty() ? this.addServerHome(startUpArgs, workingDir) : this.addOptions(terracottaServer, workingDir);
        return this.createServer(kitDir.toPath(), terracottaServer.getServerSymbolicName().getSymbolicName(), workingDir.toPath(), options);
    }

    private TerracottaServerHandle createServer(Path kitDir, String serverName, Path serverWorking, List<String> cmd) {
        LOGGER.debug("Creating TSA server: {} at: {} from: {} with CLI: {}", new Object[]{serverName, serverWorking, kitDir, String.join((CharSequence)" ", cmd)});
        final AtomicReference<Object> ref = new AtomicReference<Object>(this.startIsolatedServer(kitDir, serverName, serverWorking, cmd));
        final AtomicBoolean isAlive = new AtomicBoolean(true);
        Thread t = new Thread(() -> {
            try {
                while (((Boolean)Distribution107InlineController.invokeOnObject(ref.get(), "waitUntilShutdown", new Object[0])).booleanValue()) {
                    ref.set(this.startIsolatedServer(kitDir, serverName, serverWorking, cmd));
                }
            }
            catch (Throwable tt) {
                ref.set(null);
                LOGGER.error("restart failed", tt);
            }
            isAlive.set(false);
        });
        t.setDaemon(true);
        t.start();
        return new TerracottaServerHandle(){

            @Override
            public TerracottaServerState getState() {
                if (this.isAlive()) {
                    String state;
                    switch (state = this.invokeOnServerMBean("Server", "getState", null)) {
                        case "DIAGNOSTIC": {
                            return TerracottaServerState.STARTED_IN_DIAGNOSTIC_MODE;
                        }
                        case "START-STATE": {
                            if (Boolean.parseBoolean(this.invokeOnServerMBean("ConsistencyManager", "isBlocked", null))) {
                                return TerracottaServerState.START_SUSPENDED;
                            }
                            return TerracottaServerState.STARTING;
                        }
                        case "STOP-STATE": {
                            return TerracottaServerState.STOPPED;
                        }
                        case "ACTIVE-COORDINATOR": {
                            if (Boolean.parseBoolean(this.invokeOnServerMBean("ConsistencyManager", "isBlocked", null))) {
                                return TerracottaServerState.START_SUSPENDED;
                            }
                            if (Boolean.parseBoolean(this.invokeOnServerMBean("Server", "isAcceptingClients", null))) {
                                return TerracottaServerState.STARTED_AS_ACTIVE;
                            }
                            return TerracottaServerState.START_SUSPENDED;
                        }
                        case "PASSIVE": 
                        case "PASSIVE-SYNCING": 
                        case "PASSIVE-UNINITIALIZED": {
                            return TerracottaServerState.STARTING;
                        }
                        case "PASSIVE-STANDBY": {
                            if (Boolean.parseBoolean(this.invokeOnServerMBean("ConsistencyManager", "isBlocked", null))) {
                                return TerracottaServerState.START_SUSPENDED;
                            }
                            return TerracottaServerState.STARTED_AS_PASSIVE;
                        }
                    }
                    return !this.isAlive() || this.isStopped() ? TerracottaServerState.STOPPED : TerracottaServerState.STARTING;
                }
                return TerracottaServerState.STOPPED;
            }

            public boolean isStopped() {
                Object server = ref.get();
                if (server instanceof Future) {
                    return ((Future)server).isDone();
                }
                return (Boolean)Distribution107InlineController.invokeOnObject(server, "isStopped", new Object[0]);
            }

            @Override
            public int getJavaPid() {
                return 0;
            }

            @Override
            public boolean isAlive() {
                return isAlive.get();
            }

            @Override
            public void stop() {
                boolean stop = true;
                while (stop) {
                    stop = Boolean.parseBoolean(this.invokeOnServerMBean("Server", "stopAndWait", null));
                }
            }

            private String invokeOnServerMBean(String target, String call, String arg) {
                Object serverJMX = Distribution107InlineController.invokeOnObject(ref.get(), "getManagement", new Object[0]);
                try {
                    Method m = serverJMX.getClass().getMethod("call", String.class, String.class, String.class);
                    m.setAccessible(true);
                    return m.invoke(serverJMX, target, call, arg).toString();
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException s) {
                    LOGGER.warn("unable to call", (Throwable)s);
                    return "ERROR";
                }
            }
        };
    }

    private static Object invokeOnObject(Object server, String method, Object ... args) {
        try {
            Class[] clazz = new Class[args.length];
            for (int x = 0; x < args.length; ++x) {
                Class<?> sig;
                clazz[x] = sig = args[x] != null ? args[x].getClass() : null;
            }
            Method m = server.getClass().getMethod(method, clazz);
            m.setAccessible(true);
            return m.invoke(server, args);
        }
        catch (Exception s) {
            LOGGER.warn("unable to invoke", (Throwable)s);
            return "ERROR";
        }
    }

    private synchronized Object startIsolatedServer(Path kitDir, String serverName, Path serverWorking, List<String> cmd) {
        Path tc = kitDir.resolve(Paths.get("server", "lib", "tc.jar"));
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(null);
        try {
            URL url = tc.toUri().toURL();
            URL resource = serverWorking.toUri().toURL();
            System.setProperty("tc.install-root", kitDir.resolve("server").toString());
            IsolatedClassLoader loader = new IsolatedClassLoader(new URL[]{resource, url});
            Method m = Class.forName("com.tc.server.TCServerMain", true, loader).getMethod("createServer", List.class, OutputStream.class);
            Object object = m.invoke(null, cmd, Files.newOutputStream(serverWorking.resolve("stdout.txt"), StandardOpenOption.CREATE, StandardOpenOption.APPEND));
            return object;
        }
        catch (RuntimeException mal) {
            throw mal;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    private List<String> addServerHome(List<String> options, File workingDir) {
        ArrayList<String> args = new ArrayList<String>(options.size() + 2);
        args.add("--server-home");
        args.add(workingDir.toString());
        args.addAll(options);
        return Collections.unmodifiableList(args);
    }

    private List<String> addOptions(TerracottaServer server, File workingDir) {
        ArrayList<String> options = new ArrayList<String>();
        Path working = workingDir.toPath();
        options.add("--server-home");
        options.add(working.toString());
        if (server.getConfigFile() != null) {
            options.add("-f");
            options.add(server.getConfigFile());
        } else {
            options.add("-n");
            options.add(server.getServerSymbolicName().getSymbolicName());
        }
        options.add("-s");
        options.add(server.getHostName());
        if (server.getTsaPort() != 0) {
            options.add("-p");
            options.add(String.valueOf(server.getTsaPort()));
        }
        if (server.getTsaGroupPort() != 0) {
            options.add("-g");
            options.add(String.valueOf(server.getTsaGroupPort()));
        }
        if (server.getBindAddress() != null) {
            options.add("-a");
            options.add(server.getBindAddress());
        }
        if (server.getGroupBindAddress() != null) {
            options.add("-A");
            options.add(server.getGroupBindAddress());
        }
        if (server.getConfigRepo() != null) {
            options.add("-r");
            options.add(server.getConfigRepo());
        }
        if (server.getMetaData() != null) {
            options.add("-m");
            options.add(server.getMetaData());
        }
        if (server.getDataDir().size() != 0) {
            options.add("-d");
            options.add(server.getDataDir().stream().collect(Collectors.joining(",")));
        }
        if (server.getOffheap().size() != 0) {
            options.add("-o");
            options.add(String.join((CharSequence)",", server.getOffheap()));
        }
        if (server.getLogs() != null) {
            options.add("-L");
            options.add(server.getLogs());
        }
        if (server.getFailoverPriority() != null) {
            options.add("-y");
            options.add(server.getFailoverPriority());
        }
        if (server.getClientLeaseDuration() != null) {
            options.add("-i");
            options.add(server.getClientLeaseDuration());
        }
        if (server.getClientReconnectWindow() != null) {
            options.add("-R");
            options.add(server.getClientReconnectWindow());
        }
        if (server.getBackupDir() != null) {
            options.add("-b");
            options.add(server.getBackupDir());
        }
        if (server.getAuditLogDir() != null) {
            options.add("-u");
            options.add(server.getAuditLogDir());
        }
        if (server.getAuthc() != null) {
            options.add("-z");
            options.add(server.getAuthc());
        }
        if (server.getSecurityDir() != null) {
            options.add("-x");
            Path securityRootDirectoryPath = workingDir.toPath().resolve("security-root-directory-" + server.getServerSymbolicName().getSymbolicName());
            server.getSecurityDir().createSecurityRootDirectory(securityRootDirectoryPath);
            options.add(securityRootDirectoryPath.toString());
        }
        if (server.isSslTls()) {
            options.add("-t");
            options.add("true");
        }
        if (server.isWhitelist()) {
            options.add("-w");
            options.add("true");
        }
        if (server.getProperties() != null) {
            options.add("-T");
            options.add(server.getProperties());
        }
        if (server.getClusterName() != null) {
            options.add("-N");
            options.add(server.getClusterName());
        }
        LOGGER.debug("Server startup options: {}", options);
        return options;
    }
}

