/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.metrics;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.common.metrics.HardwareMetric;
import org.terracotta.angela.common.metrics.MonitoringCommand;
import org.terracotta.angela.common.util.ProcessUtil;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.StartedProcess;
import org.zeroturnaround.process.PidUtil;

public class HardwareMetricsCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(HardwareMetricsCollector.class);
    public static final String METRICS_DIRECTORY = "metrics";
    private OutputStream outputStream;
    private final Map<HardwareMetric, StartedProcess> processes = new HashMap<HardwareMetric, StartedProcess>();

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    public void startMonitoring(Path installLocation, Map<HardwareMetric, MonitoringCommand> commands) {
        LOGGER.info("Starting monitoring: {} into: {}", commands.keySet(), (Object)installLocation);
        Path statsDirectory = installLocation.resolve(METRICS_DIRECTORY);
        try {
            Files.createDirectories(statsDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        commands.forEach((hardwareMetric, command) -> {
            Path statsFile = statsDirectory.resolve(hardwareMetric.name().toLowerCase() + "-stats.log");
            LOGGER.debug("HardwareMetric log file: {}", (Object)statsFile.toAbsolutePath());
            try {
                this.outputStream = Files.newOutputStream(statsFile, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            ProcessExecutor pe = new ProcessExecutor().environment(System.getenv()).command(command.getCommand()).directory(installLocation.toFile()).redirectErrorStream(true).redirectOutput(this.outputStream);
            try {
                LOGGER.debug("Starting process: {} with env: {}", command.getCommand(), (Object)pe.getEnvironment());
                this.processes.put((HardwareMetric)((Object)hardwareMetric), pe.start());
            }
            catch (IOException e) {
                String msg = "Error executing command '" + command.getCommandName() + "': " + e.getMessage();
                LOGGER.error(msg, (Throwable)e);
                try {
                    Files.write(statsFile, msg.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
                catch (IOException ioe) {
                    LOGGER.warn(msg, (Throwable)ioe);
                }
            }
        });
    }

    public boolean isMonitoringRunning(HardwareMetric hardwareMetric) {
        StartedProcess process = this.processes.get((Object)hardwareMetric);
        if (process == null) {
            return false;
        }
        return process.getProcess().isAlive();
    }

    public void stopMonitoring() {
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        this.processes.values().forEach(process -> {
            try {
                ProcessUtil.destroyGracefullyOrForcefullyAndWait(PidUtil.getPid((Process)process.getProcess()));
            }
            catch (Exception e) {
                exceptions.add((IOException)e);
            }
        });
        this.processes.clear();
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException e) {
                exceptions.add(e);
            }
            this.outputStream = null;
        }
        if (!exceptions.isEmpty()) {
            RuntimeException runtimeException = new RuntimeException();
            exceptions.forEach(runtimeException::addSuppressed);
            throw runtimeException;
        }
    }
}

