/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.netcrusher.core.reactor.NioReactor;
import org.netcrusher.tcp.TcpCrusher;
import org.netcrusher.tcp.TcpCrusherBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.common.net.DisruptionProvider;
import org.terracotta.angela.common.net.Disruptor;
import org.terracotta.angela.common.net.DisruptorState;
import org.terracotta.angela.common.net.Link;

public class NetCrusherProvider
implements DisruptionProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetCrusherProvider.class);
    private final Map<Link, DisruptorLinkImpl> links = new HashMap<Link, DisruptorLinkImpl>();

    @Override
    public boolean isProxyBased() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Disruptor createLink(InetSocketAddress src, InetSocketAddress dest) {
        LOGGER.debug("creating link between source {} and destination {}", (Object)src, (Object)dest);
        Map<Link, DisruptorLinkImpl> map = this.links;
        synchronized (map) {
            Link link = new Link(src, dest);
            DisruptorLinkImpl existing = this.links.get(link);
            if (existing == null) {
                existing = new DisruptorLinkImpl(link);
                this.links.put(link, existing);
            }
            return existing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLink(Disruptor disruptor) {
        try {
            disruptor.close();
        }
        catch (Exception e) {
            LOGGER.error("Error when closing {} {} ", (Object)disruptor, (Object)e);
        }
        finally {
            Map<Link, DisruptorLinkImpl> map = this.links;
            synchronized (map) {
                this.links.remove(((DisruptorLinkImpl)disruptor).getLink());
            }
        }
    }

    private static class DisruptorLinkImpl
    implements Disruptor {
        private final NioReactor reactor;
        private final TcpCrusher crusher;
        private final Link link;
        private volatile DisruptorState state;

        public DisruptorLinkImpl(Link link) {
            this.link = link;
            try {
                this.reactor = new NioReactor();
                this.crusher = TcpCrusherBuilder.builder().withReactor(this.reactor).withBindAddress(link.getSource()).withConnectAddress(link.getDestination()).buildAndOpen();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.state = DisruptorState.UNDISRUPTED;
        }

        @Override
        public void disrupt() {
            if (this.state != DisruptorState.UNDISRUPTED) {
                throw new IllegalStateException("illegal state " + (Object)((Object)this.state));
            }
            LOGGER.info("disrupting {} ", (Object)this);
            this.crusher.freeze();
            this.state = DisruptorState.DISRUPTED;
        }

        @Override
        public void undisrupt() {
            if (this.state != DisruptorState.DISRUPTED) {
                throw new IllegalStateException("illegal state " + (Object)((Object)this.state));
            }
            LOGGER.info("undisrupting {} ", (Object)this);
            this.crusher.unfreeze();
            this.state = DisruptorState.UNDISRUPTED;
        }

        Link getLink() {
            return this.link;
        }

        @Override
        public void close() {
            if (this.state == DisruptorState.DISRUPTED) {
                this.undisrupt();
            }
            if (this.state == DisruptorState.UNDISRUPTED) {
                LOGGER.debug("closing {}", (Object)this);
                this.crusher.close();
                this.reactor.close();
                this.state = DisruptorState.CLOSED;
            }
        }

        public String toString() {
            return "DisruptorLinkImpl{link=" + this.link + ", state=" + (Object)((Object)this.state) + '}';
        }
    }
}

