/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.topology;

import java.io.Serializable;
import java.util.Objects;

public class Version
implements Comparable<Version>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int major;
    private final int minor;
    private final int revision;
    private final int build_major;
    private final int build_minor;
    private final boolean snapshot;

    public static Version version(String version) {
        return new Version(version);
    }

    Version(String version) {
        Objects.requireNonNull(version);
        String versionToSplit = version;
        if (version.endsWith("-SNAPSHOT")) {
            this.snapshot = true;
            versionToSplit = versionToSplit.split("-")[0];
        } else {
            this.snapshot = false;
        }
        String[] split = versionToSplit.split("\\.");
        if (split.length == 2 || split.length == 3 || split.length == 5) {
            this.major = this.parse(split[0]);
            this.minor = this.parseMinorVersion(split[1]);
            this.revision = split.length == 2 ? -1 : this.parseRevisionVersion(split[2]);
            if (split.length == 5) {
                this.build_major = this.parse(split[3]);
                this.build_minor = this.parse(split[4]);
            } else {
                this.build_major = -1;
                this.build_minor = -1;
            }
        } else {
            throw new IllegalArgumentException("Cannot parse string: " + version + " into a valid Version object");
        }
    }

    private int parseMinorVersion(String input) {
        int minorVersion = this.parse(input);
        if (minorVersion < 0) {
            throw new IllegalArgumentException("Expected minor version to be a positive number, but found: " + input);
        }
        return minorVersion;
    }

    private int parseRevisionVersion(String input) {
        int revision;
        if (input.contains("pre")) {
            String[] split = input.split("-");
            input = split[0];
        }
        if ((revision = this.parse(input)) < 0) {
            throw new IllegalArgumentException("Expected revision to be a positive number, but found: " + input);
        }
        return revision;
    }

    private int parse(String input) {
        int parsed = -1;
        try {
            parsed = Integer.parseInt(input);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return parsed;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getRevision() {
        return this.revision;
    }

    public int getBuild_major() {
        return this.build_major;
    }

    public int getBuild_minor() {
        return this.build_minor;
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    public String getShortVersion() {
        StringBuilder sb = new StringBuilder();
        if (this.major != -1) {
            sb.append(this.getMajor());
            if (this.minor != -1) {
                sb.append(".").append(this.getMinor());
                if (this.revision != -1) {
                    sb.append(".").append(this.getRevision());
                }
            }
        }
        return sb.toString();
    }

    public String getVersion(boolean showSnapshot) {
        StringBuilder sb = new StringBuilder();
        if (this.major != -1) {
            sb.append(this.getMajor());
            if (this.minor != -1) {
                sb.append(".").append(this.getMinor());
                if (this.revision != -1) {
                    sb.append(".").append(this.getRevision());
                    if (this.build_major != -1) {
                        sb.append(".").append(this.getBuild_major());
                        if (this.build_minor != -1) {
                            sb.append(".").append(this.getBuild_minor());
                        }
                    }
                }
            }
            if (this.isSnapshot() && showSnapshot) {
                sb.append("-SNAPSHOT");
            }
        }
        return sb.toString();
    }

    public String toString() {
        return this.getVersion(true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return this.major == version.major && this.minor == version.minor && this.revision == version.revision && this.build_major == version.build_major && this.build_minor == version.build_minor && this.snapshot == version.snapshot;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.revision, this.build_major, this.build_minor, this.snapshot);
    }

    @Override
    public int compareTo(Version ver) {
        if (this.major > ver.major) {
            return 1;
        }
        if (this.major < ver.major) {
            return -1;
        }
        if (this.minor > ver.minor) {
            return 1;
        }
        if (this.minor < ver.minor) {
            return -1;
        }
        if (this.revision > ver.revision) {
            return 1;
        }
        if (this.revision < ver.revision) {
            return -1;
        }
        if (this.build_major > ver.build_major) {
            return 1;
        }
        if (this.build_major < ver.build_major) {
            return -1;
        }
        if (this.build_minor > ver.build_minor) {
            return 1;
        }
        if (this.build_minor < ver.build_minor) {
            return -1;
        }
        if (this.snapshot) {
            return ver.snapshot ? 0 : -1;
        }
        return ver.snapshot ? 1 : 0;
    }
}

