/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.util;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import org.terracotta.angela.common.TerracottaCommandLineEnvironment;
import org.terracotta.angela.common.ToolExecutionResult;
import org.terracotta.angela.common.util.JavaBinaries;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.ProcessResult;

public class Jcmd {
    public static ToolExecutionResult jcmd(int javaPid, TerracottaCommandLineEnvironment tcEnv, String ... arguments) {
        Path javaHome = tcEnv.getJavaHome();
        Path path = JavaBinaries.find("jcmd", javaHome).orElseThrow(() -> new IllegalStateException("jcmd not found"));
        ArrayList<String> cmdLine = new ArrayList<String>();
        cmdLine.add(path.toAbsolutePath().toString());
        cmdLine.add(Integer.toString(javaPid));
        cmdLine.addAll(Arrays.asList(arguments));
        try {
            ProcessResult processResult = new ProcessExecutor(cmdLine).readOutput(true).redirectErrorStream(true).execute();
            return new ToolExecutionResult(processResult.getExitValue(), processResult.getOutput().getLines());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

