/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.dynamic_cluster;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.terracotta.angela.common.tcconfig.TerracottaServer;

public class Stripe
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<TerracottaServer> servers;

    private Stripe(TerracottaServer ... servers) {
        if (servers == null || servers.length == 0) {
            throw new IllegalArgumentException("Server list cannot be null or empty");
        }
        this.servers = new ArrayList<TerracottaServer>(Arrays.asList(servers));
    }

    public static Stripe stripe(TerracottaServer ... terracottaServers) {
        return new Stripe(terracottaServers);
    }

    public void addServer(TerracottaServer newServer) {
        this.servers.add(newServer);
    }

    public void removeServer(int serverIndex) {
        this.servers.remove(serverIndex);
    }

    public TerracottaServer getServer(int serverIndex) {
        return this.servers.get(serverIndex);
    }

    public List<TerracottaServer> getServers() {
        return Collections.unmodifiableList(this.servers);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Stripe stripe = (Stripe)o;
        return this.servers.equals(stripe.servers);
    }

    public int hashCode() {
        return Objects.hash(this.servers);
    }

    public String toString() {
        return "Stripe{servers=" + this.servers + '}';
    }
}

