/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.tcconfig;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.terracotta.angela.common.net.PortAllocator;
import org.terracotta.angela.common.tcconfig.ServerSymbolicName;
import org.terracotta.angela.common.tcconfig.TerracottaServer;
import org.terracotta.angela.common.tcconfig.TsaStripeConfig;
import org.terracotta.angela.common.tcconfig.holders.TcConfig10Holder;
import org.terracotta.angela.common.tcconfig.holders.TcConfig8Holder;
import org.terracotta.angela.common.tcconfig.holders.TcConfig9Holder;
import org.terracotta.angela.common.tcconfig.holders.TcConfigHolder;
import org.terracotta.angela.common.topology.Version;

public class TcConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final TcConfigHolder tcConfigHolder;
    protected String tcConfigName;

    public static TcConfig tcConfig(Version version, URL tcConfigPath) {
        return new TcConfig(version, tcConfigPath);
    }

    TcConfig(TcConfig tcConfig) {
        this.tcConfigName = tcConfig.tcConfigName;
        if (tcConfig.tcConfigHolder instanceof TcConfig8Holder) {
            this.tcConfigHolder = new TcConfig8Holder((TcConfig8Holder)tcConfig.tcConfigHolder);
        } else if (tcConfig.tcConfigHolder instanceof TcConfig9Holder) {
            this.tcConfigHolder = new TcConfig9Holder((TcConfig9Holder)tcConfig.tcConfigHolder);
        } else if (tcConfig.tcConfigHolder instanceof TcConfig10Holder) {
            this.tcConfigHolder = new TcConfig10Holder((TcConfig10Holder)tcConfig.tcConfigHolder);
        } else {
            throw new RuntimeException("Unexpected");
        }
    }

    TcConfig(Version version, URL tcConfigPath) {
        this.tcConfigName = new File(tcConfigPath.getPath()).getName();
        this.tcConfigHolder = this.initTcConfigHolder(version, tcConfigPath);
    }

    public TcConfig copy() {
        return new TcConfig(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected TcConfigHolder initTcConfigHolder(Version version, URL tcConfigPath) {
        try (InputStream is = tcConfigPath.openStream();){
            if (version.getMajor() == 4) {
                if (version.getMinor() == 0) {
                    TcConfig8Holder tcConfig8Holder = new TcConfig8Holder(is);
                    return tcConfig8Holder;
                }
                TcConfig9Holder tcConfig9Holder = new TcConfig9Holder(is);
                return tcConfig9Holder;
            }
            TcConfig10Holder tcConfig10Holder = new TcConfig10Holder(is);
            return tcConfig10Holder;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read tc-config file : " + tcConfigPath, e);
        }
    }

    public void initialize(PortAllocator portAllocator) {
        this.tcConfigHolder.initialize(portAllocator, tag -> !tag.equals("jmx-port") && !tag.equals("management-port"));
    }

    public List<TerracottaServer> getServers() {
        return this.tcConfigHolder.getServers();
    }

    public String getTcConfigName() {
        return this.tcConfigName;
    }

    public void setTcConfigName(String tcConfigName) {
        this.tcConfigName = tcConfigName;
    }

    public void createOrUpdateTcProperty(String name, String value) {
        this.tcConfigHolder.createOrUpdateTcProperty(name, value);
    }

    public String toXml() {
        return this.tcConfigHolder.getTcConfigContent();
    }

    public void writeTcConfigFile(File kitDir) {
        this.tcConfigHolder.writeTcConfigFile(kitDir, this.tcConfigName);
    }

    public void writeTcConfigFile(File kitDir, String name) {
        this.tcConfigHolder.writeTcConfigFile(kitDir, name);
    }

    public String getPath() {
        return this.tcConfigHolder.getTcConfigPath();
    }

    public List<String> getLogsLocation() {
        return this.tcConfigHolder.getLogsLocation();
    }

    public void updateLogsLocation(File kitDir, int stripeId) {
        this.tcConfigHolder.updateLogsLocation(kitDir, stripeId);
    }

    public void updateSecurityRootDirectoryLocation(String securityRootDirectory) {
        this.tcConfigHolder.updateSecurityRootDirectoryLocation(securityRootDirectory);
    }

    public void updateAuditDirectoryLocation(File kitDir, int stripeId) {
        this.tcConfigHolder.updateAuditDirectoryLocation(kitDir, stripeId);
    }

    public void updateDataDirectory(String rootId, String newlocation) {
        this.tcConfigHolder.updateDataDirectory(rootId, newlocation);
    }

    public Map<String, String> getDataDirectories() {
        return this.tcConfigHolder.getDataDirectories();
    }

    public List<String> getPluginServices() {
        return this.tcConfigHolder.getPluginServices();
    }

    public void updateServerHost(int serverIndex, String newServerName) {
        this.tcConfigHolder.updateServerHost(serverIndex, newServerName);
    }

    public void updateServerName(int serverIndex, String newServerName) {
        this.tcConfigHolder.updateServerName(serverIndex, newServerName);
    }

    public void updateServerPort(int serverIndex, String portName, int port) {
        this.tcConfigHolder.updateServerPort(serverIndex, portName, port);
    }

    public void addServer(int stripeIndex, String hostname) {
        this.tcConfigHolder.addServer(stripeIndex, hostname);
    }

    public List<TerracottaServer> retrieveGroupMembers(String serverName, boolean updateProxy, PortAllocator portAllocator) {
        return this.tcConfigHolder.retrieveGroupMembers(serverName, updateProxy, portAllocator);
    }

    public void updateServerGroupPort(Map<ServerSymbolicName, Integer> proxiedPorts) {
        this.tcConfigHolder.updateServerGroupPort(proxiedPorts);
    }

    public void updateServerTsaPort(Map<ServerSymbolicName, Integer> proxiedPorts) {
        this.tcConfigHolder.updateServerTsaPort(proxiedPorts);
    }

    public Map<ServerSymbolicName, Integer> retrieveTsaPorts(boolean updateForProxy, PortAllocator portAllocator) {
        return this.tcConfigHolder.retrieveTsaPorts(updateForProxy, portAllocator);
    }

    public void substituteToken(String token, String value) {
        this.tcConfigHolder.substituteToken(token, value);
    }

    public void addOffheap(String resourceName, String size, String unit) {
        this.tcConfigHolder.addOffheap(resourceName, size, unit);
    }

    public void addDataDirectoryList(List<TsaStripeConfig.TsaDataDirectory> tsaDataDirectoryList) {
        this.tcConfigHolder.addDataDirectory(tsaDataDirectoryList);
    }

    public void addPersistencePlugin(String persistenceDataName) {
        this.tcConfigHolder.addPersistencePlugin(persistenceDataName);
    }
}

