/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.terracotta.angela.common.util.FileUtils;

public class KitUtils {
    public static void extractZip(Path kitInstaller, Path kitDest) {
        try (ZipArchiveInputStream archiveIs = new ZipArchiveInputStream((InputStream)new BufferedInputStream(Files.newInputStream(kitInstaller, new OpenOption[0])));){
            KitUtils.extractArchive((ArchiveInputStream)archiveIs, kitDest);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new UncheckedIOException("Error when extracting installer package", ioe);
        }
        FileUtils.setCorrectPermissions(kitDest);
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public static void extractArchive(ArchiveInputStream archiveIs, Path pathOutput) throws IOException {
        ArchiveEntry archiveEntry;
        while ((archiveEntry = archiveIs.getNextEntry()) != null) {
            Path pathEntryOutput = pathOutput.resolve(archiveEntry.getName());
            if (archiveEntry.isDirectory()) continue;
            Path parentPath = pathEntryOutput.getParent();
            if (!Files.isDirectory(parentPath, new LinkOption[0])) {
                Files.createDirectories(parentPath, new FileAttribute[0]);
            }
            Files.copy((InputStream)archiveIs, pathEntryOutput, new CopyOption[0]);
        }
    }

    public static void extractTarGz(Path kitInstaller, Path kitDest) {
        try (TarArchiveInputStream archiveIs = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new BufferedInputStream(Files.newInputStream(kitInstaller, new OpenOption[0]))));){
            KitUtils.extractArchive((ArchiveInputStream)archiveIs, kitDest);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new UncheckedIOException("Error when extracting installer package", ioe);
        }
        FileUtils.setCorrectPermissions(kitDest);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getParentDirFromTarGz(Path localInstaller) {
        try (TarArchiveInputStream archiveIs = new TarArchiveInputStream((InputStream)new GZIPInputStream(Files.newInputStream(localInstaller, new OpenOption[0])));){
            ArchiveEntry entry = archiveIs.getNextEntry();
            String string = entry.getName().split("/")[0];
            return string;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new UncheckedIOException("Error when getting parent dir from archive", ioe);
        }
    }
}

