/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;
import java.net.URL;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.hamcrest.CoreMatchers;
import org.junit.Test;
import org.terracotta.angela.client.ClientArray;
import org.terracotta.angela.client.ClientArrayFuture;
import org.terracotta.angela.client.ClientJob;
import org.terracotta.angela.client.ClusterFactory;
import org.terracotta.angela.client.Tsa;
import org.terracotta.angela.client.config.ConfigurationContext;
import org.terracotta.angela.client.config.custom.CustomConfigurationContext;
import org.terracotta.angela.common.TerracottaServerState;
import org.terracotta.angela.common.clientconfig.ClientArrayConfig;
import org.terracotta.angela.common.distribution.Distribution;
import org.terracotta.angela.common.tcconfig.License;
import org.terracotta.angela.common.tcconfig.TcConfig;
import org.terracotta.angela.common.tcconfig.TerracottaServer;
import org.terracotta.angela.common.topology.ClientArrayTopology;
import org.terracotta.angela.common.topology.LicenseType;
import org.terracotta.angela.common.topology.PackageType;
import org.terracotta.angela.common.topology.Topology;
import org.terracotta.angela.common.topology.Version;

public class GettingStarted {
    private static final License LICENSE = LicenseType.TERRACOTTA.defaultLicense();
    private static String TERRACOTTA_VERSION;

    @Test
    public void configureCluster() throws Exception {
        CustomConfigurationContext configContext = CustomConfigurationContext.customConfigurationContext().tsa(tsa -> tsa.topology(new Topology(Distribution.distribution((Version)Version.version((String)TERRACOTTA_VERSION), (PackageType)PackageType.KIT, (LicenseType)LicenseType.TERRACOTTA), TcConfig.tcConfig((Version)Version.version((String)TERRACOTTA_VERSION), (URL)this.getClass().getResource("/tc-config-a.xml")), new TcConfig[0])).license(LICENSE));
        ClusterFactory factory = new ClusterFactory("GettingStarted::configureCluster", (ConfigurationContext)configContext);
        Tsa tsa2 = factory.tsa().startAll(new String[0]).licenseAll();
        factory.close();
    }

    @Test
    public void showTsaApi() throws Exception {
        Topology topology = new Topology(Distribution.distribution((Version)Version.version((String)TERRACOTTA_VERSION), (PackageType)PackageType.KIT, (LicenseType)LicenseType.TERRACOTTA), TcConfig.tcConfig((Version)Version.version((String)TERRACOTTA_VERSION), (URL)this.getClass().getResource("/tc-config-ap.xml")), new TcConfig[0]);
        CustomConfigurationContext configContext = CustomConfigurationContext.customConfigurationContext().tsa(tsa -> tsa.topology(topology).license(LICENSE));
        try (ClusterFactory factory = new ClusterFactory("GettingStarted::showTsaApi", (ConfigurationContext)configContext);){
            Tsa tsa2 = factory.tsa().startAll(new String[0]).licenseAll();
            TerracottaServer active = tsa2.getActive();
            Collection actives = tsa2.getActives();
            TerracottaServer passive = tsa2.getPassive();
            Collection passives = tsa2.getPassives();
            tsa2.stopAll();
            tsa2.start(active, new String[0]);
            tsa2.start(passive, new String[0]);
            tsa2.stop(active);
            Callable<TerracottaServerState> serverState = () -> tsa2.getState(passive);
            Awaitility.await().pollInterval(1L, TimeUnit.SECONDS).atMost(15L, TimeUnit.SECONDS).until(serverState, CoreMatchers.is((Object)TerracottaServerState.STARTED_AS_ACTIVE));
        }
    }

    @Test
    public void runClient() throws Exception {
        CustomConfigurationContext configContext = CustomConfigurationContext.customConfigurationContext().clientArray(clientArray -> clientArray.license(LICENSE).clientArrayTopology(new ClientArrayTopology(Distribution.distribution((Version)Version.version((String)TERRACOTTA_VERSION), (PackageType)PackageType.KIT, (LicenseType)LicenseType.TERRACOTTA), ClientArrayConfig.newClientArrayConfig().host("localhost-1", "localhost").host("localhost-2", "localhost"))));
        ClusterFactory factory = new ClusterFactory("GettingStarted::runClient", (ConfigurationContext)configContext);
        ClientArray clientArray2 = factory.clientArray();
        ClientArrayFuture f = clientArray2.executeOnAll((ClientJob & Serializable)context -> System.out.println("Hello"));
        f.get();
        factory.close();
    }
}

