/*
 * Decompiled with CFR 0.152.
 */
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.net.URL;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.hamcrest.CoreMatchers;
import org.junit.Rule;
import org.junit.Test;
import org.terracotta.angela.client.ClientArray;
import org.terracotta.angela.client.ClientArrayFuture;
import org.terracotta.angela.client.ClientJob;
import org.terracotta.angela.client.ClusterFactory;
import org.terracotta.angela.client.ConfigTool;
import org.terracotta.angela.client.Tsa;
import org.terracotta.angela.client.config.ConfigurationContext;
import org.terracotta.angela.client.config.custom.CustomConfigurationContext;
import org.terracotta.angela.client.support.junit.AngelaOrchestratorRule;
import org.terracotta.angela.common.TerracottaConfigTool;
import org.terracotta.angela.common.TerracottaServerState;
import org.terracotta.angela.common.clientconfig.ClientArrayConfig;
import org.terracotta.angela.common.distribution.Distribution;
import org.terracotta.angela.common.dynamic_cluster.Stripe;
import org.terracotta.angela.common.provider.ConfigurationManager;
import org.terracotta.angela.common.provider.DynamicConfigManager;
import org.terracotta.angela.common.tcconfig.TcConfig;
import org.terracotta.angela.common.tcconfig.TerracottaServer;
import org.terracotta.angela.common.topology.ClientArrayTopology;
import org.terracotta.angela.common.topology.LicenseType;
import org.terracotta.angela.common.topology.PackageType;
import org.terracotta.angela.common.topology.Topology;
import org.terracotta.angela.common.topology.Version;

@SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"})
public class GettingStarted {
    private static final String EHCACHE_OS_VERSION = "3.8.1";
    private static final String EHCACHE_VERSION = "3.9-SNAPSHOT";
    @Rule
    public AngelaOrchestratorRule angelaOrchestratorRule = new AngelaOrchestratorRule();

    @Test
    public void configureCluster() throws Exception {
        CustomConfigurationContext configContext = CustomConfigurationContext.customConfigurationContext().tsa(tsa -> tsa.topology(new Topology(Distribution.distribution((Version)Version.version((String)EHCACHE_OS_VERSION), (PackageType)PackageType.KIT, (LicenseType)LicenseType.TERRACOTTA_OS), TcConfig.tcConfig((Version)Version.version((String)EHCACHE_OS_VERSION), (URL)this.getClass().getResource("/tc-config-a.xml")), new TcConfig[0])));
        ClusterFactory factory = this.angelaOrchestratorRule.newClusterFactory("GettingStarted::configureCluster", (ConfigurationContext)configContext);
        Tsa tsa2 = factory.tsa().startAll(new String[0]);
        factory.close();
    }

    @Test
    public void showTsaApi() throws Exception {
        Topology topology = new Topology(Distribution.distribution((Version)Version.version((String)EHCACHE_OS_VERSION), (PackageType)PackageType.KIT, (LicenseType)LicenseType.TERRACOTTA_OS), TcConfig.tcConfig((Version)Version.version((String)EHCACHE_OS_VERSION), (URL)this.getClass().getResource("/tc-config-ap.xml")), new TcConfig[0]);
        CustomConfigurationContext configContext = CustomConfigurationContext.customConfigurationContext().tsa(tsa -> tsa.topology(topology));
        try (ClusterFactory factory = this.angelaOrchestratorRule.newClusterFactory("GettingStarted::showTsaApi", (ConfigurationContext)configContext);){
            Tsa tsa2 = factory.tsa().startAll(new String[0]);
            TerracottaServer active = tsa2.getActive();
            Collection actives = tsa2.getActives();
            TerracottaServer passive = tsa2.getPassive();
            Collection passives = tsa2.getPassives();
            tsa2.stopAll();
            tsa2.start(active, new String[0]);
            tsa2.start(passive, new String[0]);
            tsa2.stop(active);
            Callable<TerracottaServerState> serverState = () -> tsa2.getState(passive);
            Awaitility.await().pollInterval(1L, TimeUnit.SECONDS).atMost(15L, TimeUnit.SECONDS).until(serverState, CoreMatchers.is((Object)TerracottaServerState.STARTED_AS_ACTIVE));
        }
    }

    @Test
    public void showDynamicTsaApi() throws Exception {
        CustomConfigurationContext configContext = CustomConfigurationContext.customConfigurationContext().tsa(context -> context.topology(new Topology(Distribution.distribution((Version)Version.version((String)EHCACHE_VERSION), (PackageType)PackageType.KIT, (LicenseType)LicenseType.TERRACOTTA_OS), (ConfigurationManager)DynamicConfigManager.dynamicCluster((Stripe[])new Stripe[]{Stripe.stripe((TerracottaServer[])new TerracottaServer[]{TerracottaServer.server((String)"server-1", (String)"localhost").tsaPort(9410).tsaGroupPort(9411).configRepo("terracotta1/repository").logs("terracotta1/logs").metaData("terracotta1/metadata").failoverPriority("availability"), TerracottaServer.server((String)"server-2", (String)"localhost").tsaPort(9510).tsaGroupPort(9511).configRepo("terracotta2/repository").logs("terracotta2/logs").metaData("terracotta2/metadata").failoverPriority("availability")})})))).configTool(context -> context.configTool(TerracottaConfigTool.configTool((String)"configTool", (String)"localhost")));
        try (ClusterFactory factory = this.angelaOrchestratorRule.newClusterFactory("DynamicClusterTest::testSingleStripeFormation", (ConfigurationContext)configContext);){
            Tsa tsa = factory.tsa();
            tsa.startAll(new String[0]);
            ConfigTool configTool = factory.configTool();
            configTool.attachAll();
            configTool.attachStripe(new TerracottaServer[]{TerracottaServer.server((String)"server-3", (String)"localhost").tsaPort(9610).tsaGroupPort(9611).configRepo("terracotta3/repository").logs("terracotta3/logs").metaData("terracotta3/metadata").failoverPriority("availability")});
            TerracottaServer toDetach = tsa.getServer(0, 1);
            configTool.detachNode(0, 1);
            tsa.stop(toDetach);
            configTool.activate();
        }
    }

    @Test
    public void runClient() throws Exception {
        CustomConfigurationContext configContext = CustomConfigurationContext.customConfigurationContext().clientArray(clientArray -> clientArray.clientArrayTopology(new ClientArrayTopology(Distribution.distribution((Version)Version.version((String)EHCACHE_OS_VERSION), (PackageType)PackageType.KIT, (LicenseType)LicenseType.TERRACOTTA_OS), ClientArrayConfig.newClientArrayConfig().host("localhost-1", "localhost").host("localhost-2", "localhost"))));
        ClusterFactory factory = this.angelaOrchestratorRule.newClusterFactory("GettingStarted::runClient", (ConfigurationContext)configContext);
        ClientArray clientArray2 = factory.clientArray(0);
        ClientArrayFuture f = clientArray2.executeOnAll((ClientJob & Serializable)context -> System.out.println("Hello"));
        f.get();
        factory.close();
    }
}

