/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ipceventbus.event;

import org.terracotta.ipceventbus.event.Assert;
import org.terracotta.ipceventbus.event.DefaultEvent;
import org.terracotta.ipceventbus.event.ErrorListener;
import org.terracotta.ipceventbus.event.Event;
import org.terracotta.ipceventbus.event.EventBus;
import org.terracotta.ipceventbus.event.EventListener;
import org.terracotta.ipceventbus.event.Listeners;

class DefaultEventBus
implements EventBus {
    private final String uuid;
    private final ErrorListener errorListener;
    protected final Listeners listeners = new Listeners();

    DefaultEventBus(String uuid, ErrorListener errorListener) {
        this.uuid = uuid;
        this.errorListener = errorListener;
    }

    @Override
    public String getId() {
        return this.uuid;
    }

    @Override
    public void on(String event, EventListener listener) {
        Assert.legalEventName(event);
        this.listeners.on(event).add(listener);
    }

    @Override
    public void on(EventListener listener) {
        this.listeners.on("").add(listener);
    }

    @Override
    public void trigger(String name) {
        this.trigger(name, null);
    }

    @Override
    public void trigger(String name, Object data) {
        Assert.legalEventName(name);
        Assert.notInternalName(name);
        DefaultEvent event = new DefaultEvent(this.getId(), name, data);
        this.sendLocal(event);
    }

    void sendLocal(Event event) {
        for (EventListener listener : this.listeners.on(event.getName())) {
            try {
                listener.onEvent(event);
            }
            catch (Throwable e) {
                this.errorListener.onError(event, listener, e);
            }
        }
        for (EventListener listener : this.listeners.on("")) {
            try {
                listener.onEvent(event);
            }
            catch (Throwable e) {
                this.errorListener.onError(event, listener, e);
            }
        }
    }

    @Override
    public void unbind(String event) {
        Assert.legalEventName(event);
        Assert.notInternalName(event);
        this.listeners.removeAll(event);
    }

    @Override
    public void unbind(EventListener listener) {
        this.listeners.removeAll(listener);
    }

    @Override
    public void unbind(String event, EventListener listener) {
        Assert.legalEventName(event);
        this.listeners.remove(event, listener);
    }

    public String toString() {
        return EventBus.class.getSimpleName() + ":" + this.getId();
    }
}

