/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ipceventbus.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;

public final class Pipe
implements Closeable {
    private volatile Thread pipe;

    public Pipe(String name, InputStream in, OutputStream out) {
        this(name, in, out, 8192);
    }

    public Pipe(String name, final InputStream in, final OutputStream out, final int bufferSize) {
        this.pipe = new Thread(name){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                byte[] buffer = new byte[bufferSize];
                try {
                    int len;
                    while (!Thread.currentThread().isInterrupted() && (len = in.read(buffer)) != -1) {
                        out.write(buffer, 0, len);
                        out.flush();
                    }
                }
                catch (InterruptedIOException ignored) {
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    Pipe.this.close();
                }
            }
        };
        this.pipe.setDaemon(true);
        this.pipe.start();
    }

    public void waitFor() throws InterruptedException {
        if (this.pipe != null) {
            this.pipe.join();
            this.close();
        }
    }

    @Override
    public synchronized void close() {
        if (this.pipe != null) {
            Thread t = this.pipe;
            this.pipe = null;
            t.interrupt();
        }
    }
}

