/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ipceventbus.proc;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.terracotta.ipceventbus.event.Event;
import org.terracotta.ipceventbus.event.EventListener;
import org.terracotta.ipceventbus.proc.Bus;

public final class Boot {
    public static void main(String[] args) throws Throwable {
        if (System.getProperty("ipc.bus.mainClass") == null) {
            throw new IllegalStateException("No main class specified");
        }
        Class<?> mainClass = Class.forName(System.getProperty("ipc.bus.mainClass"));
        if (Bus.isDebug()) {
            System.out.println("[" + Boot.class.getSimpleName() + "] Starting " + mainClass.getName() + "...");
        }
        final AtomicBoolean firedExiting = new AtomicBoolean();
        Bus.get().on("process.exit", new EventListener(){

            @Override
            @SuppressFBWarnings(value={"DM_EXIT"})
            public void onEvent(Event e) {
                if (firedExiting.compareAndSet(false, true)) {
                    Bus.get().trigger("process.exiting", Bus.getCurrentPid());
                }
                System.exit(e.getData(Integer.class, 0));
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (firedExiting.compareAndSet(false, true)) {
                    Bus.get().trigger("process.exiting", Bus.getCurrentPid());
                }
            }
        });
        try {
            mainClass.getDeclaredMethod("main", String[].class).invoke(null, new Object[]{args});
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        finally {
            Thread current = Thread.currentThread();
            for (Thread thread : Thread.getAllStackTraces().keySet()) {
                if (thread.isDaemon() || current == thread) continue;
                try {
                    thread.join();
                }
                catch (InterruptedException ignored) {}
            }
            if (firedExiting.compareAndSet(false, true)) {
                Bus.get().trigger("process.exiting");
            }
        }
    }
}

