/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ipceventbus.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class MultiplexOutputStream
extends OutputStream {
    private List<OutputStream> streams = new ArrayList<OutputStream>(2);

    public MultiplexOutputStream() {
    }

    public MultiplexOutputStream(OutputStream os) {
        this.addOutputStream(os);
    }

    public List<OutputStream> getOutputStreams() {
        return this.streams;
    }

    public MultiplexOutputStream addOutputStream(OutputStream os) {
        this.streams.add(os);
        return this;
    }

    public boolean isEmpty() {
        return this.streams.isEmpty();
    }

    public int streamCount() {
        return this.streams.size();
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() throws IOException {
        IOException ioe = null;
        for (OutputStream stream : this.streams) {
            try {
                stream.flush();
            }
            catch (IOException e) {
                ioe = e;
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    @Override
    public void write(int b) throws IOException {
        IOException ioe = null;
        for (OutputStream stream : this.streams) {
            try {
                stream.write(b);
            }
            catch (IOException e) {
                ioe = e;
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        IOException ioe = null;
        for (OutputStream stream : this.streams) {
            try {
                stream.write(b);
            }
            catch (IOException e) {
                ioe = e;
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        IOException ioe = null;
        for (OutputStream stream : this.streams) {
            try {
                stream.write(b, off, len);
            }
            catch (IOException e) {
                ioe = e;
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }
}

