/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ipceventbus.proc;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.terracotta.ipceventbus.proc.AnyProcess;
import org.terracotta.ipceventbus.proc.JavaProcessBuilder;

public class JavaProcess
extends AnyProcess {
    private final File javaHome;
    private final File javaExecutable;
    private final List<String> jvmArgs;
    private final Map<String, String> jvmProperties;
    private final List<File> classpath;
    private final String mainClass;
    private final List<String> arguments;

    public JavaProcess(Process process, OutputStream pipeStdout, OutputStream pipeStderr, InputStream pipeStdin, boolean collectStdout, boolean collectStderr, List<String> command, File workingDir, File javaHome, File javaExecutable, List<String> jvmArgs, List<File> classpath, String mainClass, List<String> arguments, Map<String, String> jvmProperties) {
        super(process, pipeStdout, pipeStderr, pipeStdin, collectStdout, collectStderr, command, workingDir);
        this.javaHome = javaHome;
        this.javaExecutable = javaExecutable;
        this.jvmArgs = Collections.unmodifiableList(jvmArgs);
        this.classpath = Collections.unmodifiableList(classpath);
        this.mainClass = mainClass;
        this.arguments = Collections.unmodifiableList(arguments);
        this.jvmProperties = Collections.unmodifiableMap(jvmProperties);
    }

    public final Map<String, String> getJvmProperties() {
        return this.jvmProperties;
    }

    public final File getJavaHome() {
        return this.javaHome;
    }

    public final File getJavaExecutable() {
        return this.javaExecutable;
    }

    public final List<String> getJvmArgs() {
        return this.jvmArgs;
    }

    public final List<File> getClasspath() {
        return this.classpath;
    }

    public final String getMainClass() {
        return this.mainClass;
    }

    public final List<String> getArguments() {
        return this.arguments;
    }

    public static JavaProcessBuilder<? extends JavaProcess> newBuilder() {
        return new JavaProcessBuilder();
    }
}

