/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ipceventbus.event;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import javax.net.ServerSocketFactory;
import org.terracotta.ipceventbus.event.BaseBuilder;
import org.terracotta.ipceventbus.event.DefaultEventBusServer;
import org.terracotta.ipceventbus.event.EventBusException;
import org.terracotta.ipceventbus.event.EventBusIOException;
import org.terracotta.ipceventbus.event.PrintingErrorListener;
import org.terracotta.ipceventbus.event.RemoteEventBus;

public interface EventBusServer
extends RemoteEventBus {

    public static final class Builder
    extends BaseBuilder<Builder> {
        int port = Integer.parseInt(System.getProperty("ipc.bus.port", "56789"));
        String address = "0.0.0.0";

        public Builder() {
            this.errorListener = new PrintingErrorListener();
        }

        public Builder bind(String address) {
            this.address = address;
            return this;
        }

        public Builder listen(int port) {
            this.port = port;
            return this;
        }

        public Builder listenRandom() {
            this.port = 0;
            return this;
        }

        @Override
        public EventBusServer build() throws EventBusException {
            try {
                ServerSocket serverSocket = ServerSocketFactory.getDefault().createServerSocket();
                serverSocket.bind(new InetSocketAddress(this.address, this.port));
                return new DefaultEventBusServer(this.busId != null ? this.busId : serverSocket.getInetAddress().getHostAddress() + ":" + serverSocket.getLocalPort(), serverSocket, this.errorListener);
            }
            catch (IOException e) {
                throw new EventBusIOException("Cannot bind on " + this.address + ":" + this.port + " : " + e.getMessage(), e);
            }
        }
    }
}

