/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ipceventbus.proc;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.terracotta.ipceventbus.io.MultiplexOutputStream;
import org.terracotta.ipceventbus.io.Pipe;
import org.terracotta.ipceventbus.proc.AnyProcessBuilder;
import org.terracotta.ipceventbus.proc.Jna;

public class AnyProcess
extends Process {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final long pid;
    private final Process process;
    private volatile boolean running = true;
    private volatile boolean destroyed;
    private final FutureTask<Integer> future;
    private final Collection<Pipe> pipes = new ArrayList<Pipe>(3);
    private final ByteArrayOutputStream recordedStdout;
    private final ByteArrayOutputStream recordedStderr;
    private final List<String> command;
    private final File workingDirectory;
    private boolean stdoutStreamDisabled;
    private boolean stderrStreamDisabled;

    AnyProcess(Process process, OutputStream pipeStdout, OutputStream pipeStderr, InputStream pipeStdin, boolean collectStdout, boolean collectStderr, List<String> command, File workingDirectory) {
        this.process = process;
        this.pid = AnyProcess.getPid(process);
        this.command = Collections.unmodifiableList(command);
        this.workingDirectory = workingDirectory;
        if (pipeStdin != null) {
            this.pipes.add(new Pipe("Process Pipe stdin@" + this.pid, pipeStdin, this.getOutputStream()));
        }
        MultiplexOutputStream stdoutPlex = new MultiplexOutputStream();
        if (pipeStdout != null) {
            stdoutPlex.addOutputStream(pipeStdout);
        }
        if (collectStdout) {
            this.recordedStdout = new ByteArrayOutputStream();
            stdoutPlex.addOutputStream(this.recordedStdout);
        } else {
            this.recordedStdout = null;
        }
        if (!stdoutPlex.isEmpty()) {
            this.pipes.add(new Pipe("Process Pipe stdout@" + this.pid, this.getInputStream(), stdoutPlex));
            this.stdoutStreamDisabled = true;
        }
        MultiplexOutputStream stderrPlex = new MultiplexOutputStream();
        if (pipeStderr != null) {
            stderrPlex.addOutputStream(pipeStderr);
        }
        if (collectStderr) {
            this.recordedStderr = new ByteArrayOutputStream();
            stderrPlex.addOutputStream(this.recordedStderr);
        } else {
            this.recordedStderr = null;
        }
        if (!stderrPlex.isEmpty()) {
            this.pipes.add(new Pipe("Process Pipe stderr@" + this.pid, this.getErrorStream(), stderrPlex));
            this.stderrStreamDisabled = true;
        }
        this.future = new FutureTask<Integer>((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int r = AnyProcess.this.process.waitFor();
                AnyProcess.this.processFinished();
                return r;
            }
        }){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                if (mayInterruptIfRunning) {
                    AnyProcess.this.process.destroy();
                }
                boolean interrupted = false;
                try {
                    AnyProcess.this.process.waitFor();
                }
                catch (InterruptedException ignored) {
                    interrupted = true;
                }
                try {
                    AnyProcess.this.destroyed = true;
                    AnyProcess.this.processFinished();
                    boolean bl = super.cancel(mayInterruptIfRunning);
                    return bl;
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        };
        Thread thread = new Thread(this.future, "Process future@" + this.pid);
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public final OutputStream getOutputStream() {
        if (!this.isRunning()) {
            throw new IllegalStateException("Not running");
        }
        return this.process.getOutputStream();
    }

    @Override
    public final InputStream getInputStream() {
        if (!this.isRunning()) {
            throw new IllegalStateException("Not running");
        }
        if (this.stdoutStreamDisabled) {
            throw new IllegalStateException("no stdout stream available");
        }
        return this.process.getInputStream();
    }

    @Override
    public final InputStream getErrorStream() {
        if (!this.isRunning()) {
            throw new IllegalStateException("Not running");
        }
        if (this.stderrStreamDisabled) {
            throw new IllegalStateException("No stderr stream available");
        }
        return this.process.getErrorStream();
    }

    @Override
    public final int waitFor() throws InterruptedException {
        if (!this.isRunning()) {
            return this.process.exitValue();
        }
        try {
            return this.future.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof InterruptedException) {
                throw (InterruptedException)e.getCause();
            }
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    public final int waitForTime(long time, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (!this.isRunning()) {
            return this.process.exitValue();
        }
        try {
            return this.future.get(time, unit);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof InterruptedException) {
                throw (InterruptedException)e.getCause();
            }
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    @Override
    public final int exitValue() {
        int c = this.process.exitValue();
        this.processFinished();
        return c;
    }

    private void processFinished() {
        if (this.destroyed) {
            this.finishPipe(false);
        } else {
            this.finishPipe(true);
        }
        this.running = false;
        if (this.destroyed) {
            this.onDestroyed();
        } else {
            this.onTerminated();
        }
    }

    @Override
    public final void destroy() {
        this.future.cancel(true);
    }

    public String toString() {
        return this.getCommandLine();
    }

    public final List<String> getCommand() {
        return this.command;
    }

    public final String getCommandLine() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.command.get(0));
        for (int i = 1; i < this.command.size(); ++i) {
            sb.append(" ").append(this.command.get(i));
        }
        return sb.toString();
    }

    public final File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public final long getPid() {
        return this.pid;
    }

    public final boolean isRunning() {
        return this.running;
    }

    public final boolean isDestroyed() {
        return this.destroyed;
    }

    public final Future<Integer> getFuture() {
        return this.future;
    }

    public final byte[] getRecordedStdout() throws IllegalThreadStateException {
        if (this.recordedStdout == null) {
            throw new IllegalThreadStateException("Stdout not recorded.");
        }
        if (this.isRunning()) {
            throw new IllegalThreadStateException("Process not terminated.");
        }
        return this.recordedStdout.toByteArray();
    }

    public final byte[] getRecordedStderr() throws IllegalThreadStateException {
        if (this.recordedStderr == null) {
            throw new IllegalThreadStateException("Stderr not recorded.");
        }
        if (this.isRunning()) {
            throw new IllegalThreadStateException("Process not terminated.");
        }
        return this.recordedStderr.toByteArray();
    }

    public final String getRecordedStdoutText() throws IllegalThreadStateException {
        return new String(this.getRecordedStdout(), UTF8);
    }

    public final String getRecordedStderrText() throws IllegalThreadStateException {
        return new String(this.getRecordedStderr(), UTF8);
    }

    protected void onTerminated() {
    }

    protected void onDestroyed() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishPipe(boolean wait) {
        Collection<Pipe> collection = this.pipes;
        synchronized (collection) {
            for (Pipe pipe : this.pipes) {
                try {
                    if (wait) {
                        try {
                            pipe.waitFor();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            pipe.close();
                            break;
                        }
                    }
                    pipe.close();
                }
                catch (Throwable throwable) {
                    pipe.close();
                    throw throwable;
                }
            }
            this.pipes.clear();
        }
    }

    public static AnyProcessBuilder<? extends AnyProcess> newBuilder() {
        return new AnyProcessBuilder();
    }

    private static long getPid(Process process) {
        if (AnyProcess.isWindows()) {
            if (AnyProcess.isJnaAvailable()) {
                return Jna.getWindowsPid(process);
            }
        } else if (process.getClass().getName().equals("java.lang.UNIXProcess")) {
            try {
                Field f = process.getClass().getDeclaredField("pid");
                f.setAccessible(true);
                return f.getInt(process);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return -1L;
    }

    private static boolean isJnaAvailable() {
        try {
            AnyProcess.class.getClassLoader().loadClass("com.sun.jna.platform.win32.Kernel32");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    protected static boolean isWindows() {
        return System.getProperty("os.name", "unknown").toLowerCase().contains("windows");
    }

    protected final String getCurrentPid() {
        try {
            return ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
        }
        catch (Exception ignored) {
            return null;
        }
    }
}

