/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ipceventbus.proc;

import java.lang.management.ManagementFactory;
import org.terracotta.ipceventbus.event.EventBusServer;
import org.terracotta.ipceventbus.event.EventListenerSniffer;
import org.terracotta.ipceventbus.proc.Boot;

public final class Bus {
    private static final EventBusServer bus;

    public static EventBusServer get() {
        return bus;
    }

    public static boolean isDebug() {
        return System.getProperty("ipc.bus.debug") != null;
    }

    static String getCurrentPid() {
        try {
            return ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
        }
        catch (Exception ignored) {
            return null;
        }
    }

    static {
        int port = 0;
        if (System.getProperty("ipc.bus.port") != null) {
            port = Integer.parseInt(System.getProperty("ipc.bus.port"));
        }
        String pid = Bus.getCurrentPid();
        if (Bus.isDebug()) {
            System.out.println("[" + Boot.class.getSimpleName() + "] Child PID: " + pid);
            System.out.println("[" + Boot.class.getSimpleName() + "] Starting EventBus Server " + pid + " on 0.0.0.0:" + port + "...");
        }
        bus = ((EventBusServer.Builder)new EventBusServer.Builder().listen(port).id(pid)).build();
        if (Bus.isDebug()) {
            bus.on(new EventListenerSniffer(pid));
        }
    }
}

