/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ipceventbus.proc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.terracotta.ipceventbus.event.EventBus;
import org.terracotta.ipceventbus.event.EventBusClient;
import org.terracotta.ipceventbus.event.EventBusIOException;
import org.terracotta.ipceventbus.event.EventListener;
import org.terracotta.ipceventbus.event.EventListenerSniffer;
import org.terracotta.ipceventbus.proc.EventJavaProcessBuilder;
import org.terracotta.ipceventbus.proc.JavaProcess;

public final class EventJavaProcess
extends JavaProcess {
    private volatile EventBus eventBus;

    public EventJavaProcess(Process process, OutputStream pipeStdout, OutputStream pipeStderr, InputStream pipeStdin, boolean collectStdout, boolean collectStderr, List<String> command, File workingDir, File javaHome, File javaExecutable, List<String> jvmArgs, List<File> classpath, String mainClass, List<String> arguments, Map<String, String> jvmProperties, int port, boolean debug) {
        super(process, pipeStdout, pipeStderr, pipeStdin, collectStdout, collectStderr, command, workingDir, javaHome, javaExecutable, jvmArgs, classpath, mainClass, arguments, jvmProperties);
        String pid = this.getCurrentPid();
        EventBus eb = null;
        for (int i = 0; i < 4 && this.isRunning(); ++i) {
            try {
                eb = ((EventBusClient.Builder)new EventBusClient.Builder().connect(port).id(pid)).build();
                break;
            }
            catch (EventBusIOException e) {
                if (i == 3) {
                    process.destroy();
                    throw new EventBusIOException("Unable to connect to child process " + this.getPid() + " within 2 seconds.");
                }
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException e1) {
                    process.destroy();
                    Thread.currentThread().interrupt();
                    throw new EventBusIOException("Unable to connect to child process " + this.getPid() + ": connection interrupted.", e1);
                }
            }
        }
        EventBus eventBus = this.eventBus = eb != null ? eb : ((EventBus.Builder)new EventBus.Builder().id(pid)).build();
        if (debug) {
            this.eventBus.on(new EventListenerSniffer(pid));
        }
    }

    @Override
    protected void onDestroyed() {
        if (this.eventBus != null) {
            this.eventBus.trigger("process.destroyed");
        }
        this.close();
    }

    @Override
    protected void onTerminated() {
        if (this.eventBus != null) {
            this.eventBus.trigger("process.exited");
        }
        this.close();
    }

    private void close() {
        try {
            if (this.eventBus != null && this.eventBus instanceof EventBusClient && !((EventBusClient)this.eventBus).isClosed()) {
                ((EventBusClient)this.eventBus).close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final boolean isEventBusConnected() {
        return this.eventBus instanceof EventBusClient && !((EventBusClient)this.eventBus).isClosed();
    }

    public final String getEventBusServerHost() {
        return this.eventBus instanceof EventBusClient ? ((EventBusClient)this.eventBus).getServerHost() : null;
    }

    public final int getEventBusServerPort() {
        return this.eventBus instanceof EventBusClient ? ((EventBusClient)this.eventBus).getServerPort() : -1;
    }

    public final String getEventBusId() {
        return this.eventBus.getId();
    }

    public final void on(String event, EventListener listener) {
        this.eventBus.on(event, listener);
    }

    public final void unbind(String event) {
        this.eventBus.unbind(event);
    }

    public final void on(EventListener listener) {
        this.eventBus.on(listener);
    }

    public final void unbind(EventListener listener) {
        this.eventBus.unbind(listener);
    }

    public final void unbind(String event, EventListener listener) {
        this.eventBus.unbind(event, listener);
    }

    public final void trigger(String name) {
        this.eventBus.trigger(name);
    }

    public final void trigger(String name, Object data) {
        this.eventBus.trigger(name, data);
    }

    public static EventJavaProcessBuilder<? extends EventJavaProcess> newBuilder() {
        return new EventJavaProcessBuilder();
    }
}

