/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ipceventbus.proc;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.List;
import java.util.Random;
import org.terracotta.ipceventbus.proc.Boot;
import org.terracotta.ipceventbus.proc.Bus;
import org.terracotta.ipceventbus.proc.EventJavaProcess;
import org.terracotta.ipceventbus.proc.JavaProcessBuilder;

public class EventJavaProcessBuilder<T extends EventJavaProcess>
extends JavaProcessBuilder<T> {
    int port;

    public EventJavaProcessBuilder<T> port(int port) {
        this.port = port;
        return this;
    }

    public EventJavaProcessBuilder<T> randomPort() {
        return this.port(0);
    }

    @Override
    protected void buildCommand() {
        if (this.port > 0) {
            try {
                new ServerSocket(this.port).close();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot listen on port " + this.port + ": " + e.getMessage(), e);
            }
        } else {
            while (true) {
                this.port = 1025 + new Random().nextInt(64000);
                try {
                    new ServerSocket(this.port).close();
                }
                catch (IOException iOException) {
                    continue;
                }
                break;
            }
        }
        this.addClasspath(Bus.class);
        this.addJvmProp("ipc.bus.port", "" + this.port);
        if (this.debug) {
            this.addJvmProp("ipc.bus.debug", "true");
        }
        if (this.mainClass != null) {
            this.addJvmProp("ipc.bus.mainClass", this.mainClass);
            this.mainClass(Boot.class.getName());
        }
        super.buildCommand();
    }

    @Override
    protected T wrap(Process process, List<String> command) {
        return (T)new EventJavaProcess(process, this.pipeStdout, this.pipeStderr, this.pipeStdin, this.recordStdout, this.recordStderr, command, this.workingDir, this.javaHome, this.javaExecutable, this.jvmArgs, this.classpath, this.mainClass, this.arguments, this.jvmProps, this.port, this.debug);
    }
}

