/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ipceventbus.event;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.terracotta.ipceventbus.event.Assert;
import org.terracotta.ipceventbus.event.DefaultEvent;
import org.terracotta.ipceventbus.event.DefaultEventBus;
import org.terracotta.ipceventbus.event.ErrorListener;
import org.terracotta.ipceventbus.event.Event;
import org.terracotta.ipceventbus.event.EventBusClient;
import org.terracotta.ipceventbus.event.EventBusIOException;

class DefaultEventBusClient
extends DefaultEventBus
implements EventBusClient {
    private final AtomicReference<Socket> socket = new AtomicReference();
    private ObjectOutputStream outputStream;
    private ObjectInputStream inputStream;
    private Thread receiver;

    DefaultEventBusClient(Socket socket, ErrorListener listener) {
        this(socket.getLocalAddress().getHostName() + ":" + socket.getLocalPort(), socket, listener);
    }

    DefaultEventBusClient(String uuid, Socket socket, ErrorListener listener) {
        super(uuid, listener);
        this.socket.set(socket);
        try {
            this.outputStream = new ObjectOutputStream(socket.getOutputStream());
            this.inputStream = new ObjectInputStream(socket.getInputStream());
        }
        catch (IOException e) {
            this.close();
            throw new EventBusIOException("Bad socket: " + socket + " : " + e.getMessage(), e);
        }
        final CountDownLatch receiving = new CountDownLatch(1);
        this.receiver = new Thread("reader@" + this.getId()){

            @Override
            public void run() {
                receiving.countDown();
                while (!Thread.currentThread().isInterrupted() && !DefaultEventBusClient.this.isClosed()) {
                    Event event = null;
                    try {
                        event = (Event)DefaultEventBusClient.this.inputStream.readObject();
                    }
                    catch (IOException | ClassNotFoundException e) {
                        DefaultEventBusClient.this.sendLocal(new DefaultEvent(DefaultEventBusClient.this.getId(), "eventbus.client.error", e));
                        DefaultEventBusClient.this.close();
                    }
                    if (event == null || !"eventbus.event".equals(event.getName())) continue;
                    DefaultEventBusClient.this.sendLocal(event.getData(Event.class));
                }
            }
        };
        this.receiver.setDaemon(true);
        this.receiver.start();
        try {
            receiving.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void close() {
        Socket s;
        if (!this.isClosed() && (s = this.socket.get()) != null && this.socket.compareAndSet(s, null)) {
            try {
                s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.outputStream = null;
            this.inputStream = null;
            if (this.receiver != null) {
                this.receiver.interrupt();
                this.receiver = null;
            }
            this.sendLocal(new DefaultEvent(this.getId(), "eventbus.client.disconnect"));
        }
    }

    @Override
    public int getServerPort() {
        return this.socket.get().getPort();
    }

    @Override
    public String getServerHost() {
        return this.socket.get().getInetAddress().getHostName();
    }

    @Override
    public boolean isClosed() {
        return this.socket.get() == null || this.socket.get().isClosed();
    }

    @Override
    public void trigger(String name, Object data) {
        Assert.legalEventName(name);
        Assert.notInternalName(name);
        DefaultEvent event = new DefaultEvent(this.getId(), name, data);
        this.sendLocal(event);
        this.sendRemote(event);
    }

    void sendRemote(Event event) {
        if (!this.isClosed()) {
            try {
                this.outputStream.writeObject(new DefaultEvent(this.getId(), "eventbus.event", event));
                this.outputStream.flush();
            }
            catch (IOException e) {
                this.close();
            }
        }
    }

    @Override
    public String toString() {
        return EventBusClient.class.getSimpleName() + ":" + this.getId();
    }
}

