/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ipceventbus.event;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.terracotta.ipceventbus.event.Assert;
import org.terracotta.ipceventbus.event.DefaultEvent;
import org.terracotta.ipceventbus.event.DefaultEventBus;
import org.terracotta.ipceventbus.event.DefaultEventBusClient;
import org.terracotta.ipceventbus.event.ErrorListener;
import org.terracotta.ipceventbus.event.Event;
import org.terracotta.ipceventbus.event.EventBusServer;
import org.terracotta.ipceventbus.event.EventListener;

final class DefaultEventBusServer
extends DefaultEventBus
implements EventBusServer {
    private final Collection<DefaultEventBusClient> clients = new LinkedList<DefaultEventBusClient>();
    private final ReadWriteLock clientsLock = new ReentrantReadWriteLock();
    private final AtomicReference<ServerSocket> serverSocket = new AtomicReference();
    private Thread acceptor;

    DefaultEventBusServer(String uuid, ServerSocket serverSocket, final ErrorListener errorListener) {
        super(uuid, errorListener);
        this.serverSocket.set(serverSocket);
        final EventListener listener = new EventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEvent(Event e) {
                DefaultEventBusServer.this.sendLocal(e);
                if (!e.isUserEvent() && "eventbus.client.disconnect".equals(e.getName())) {
                    for (DefaultEventBusClient cli : DefaultEventBusServer.this.getClients()) {
                        if (!cli.getId().equals(e.getSource())) continue;
                        DefaultEventBusServer.this.clientsLock.writeLock().lock();
                        try {
                            DefaultEventBusServer.this.clients.remove(cli);
                            break;
                        }
                        finally {
                            DefaultEventBusServer.this.clientsLock.writeLock().unlock();
                        }
                    }
                }
            }
        };
        final CountDownLatch listening = new CountDownLatch(1);
        this.acceptor = new Thread("client-acceptor"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                listening.countDown();
                while (!Thread.currentThread().isInterrupted() && !DefaultEventBusServer.this.isClosed()) {
                    try {
                        Socket socket = ((ServerSocket)DefaultEventBusServer.this.serverSocket.get()).accept();
                        InetSocketAddress address = (InetSocketAddress)socket.getRemoteSocketAddress();
                        DefaultEventBusClient client = new DefaultEventBusClient(address.getHostName() + ":" + address.getPort(), socket, errorListener);
                        client.on(listener);
                        DefaultEventBusServer.this.clientsLock.writeLock().lock();
                        try {
                            DefaultEventBusServer.this.clients.add(client);
                        }
                        finally {
                            DefaultEventBusServer.this.clientsLock.writeLock().unlock();
                        }
                        DefaultEventBusServer.this.sendLocal(new DefaultEvent(DefaultEventBusServer.this.getId(), "eventbus.client.connect", client.getId()));
                    }
                    catch (IOException e) {
                        DefaultEventBusServer.this.close();
                    }
                }
            }
        };
        this.acceptor.setDaemon(true);
        this.acceptor.start();
        try {
            listening.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int getServerPort() {
        return this.serverSocket.get().getLocalPort();
    }

    @Override
    public boolean isClosed() {
        return this.serverSocket.get() == null || this.serverSocket.get().isClosed();
    }

    @Override
    public void close() {
        ServerSocket ss;
        if (!this.isClosed() && (ss = this.serverSocket.get()) != null && this.serverSocket.compareAndSet(ss, null)) {
            try {
                ss.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.acceptor.interrupt();
            this.acceptor = null;
            for (DefaultEventBusClient client : this.getClients()) {
                client.close();
            }
            this.sendLocal(new DefaultEvent(this.getId(), "eventbus.server.close"));
        }
    }

    @Override
    public synchronized void trigger(String name, Object data) {
        Assert.legalEventName(name);
        Assert.notInternalName(name);
        DefaultEvent event = new DefaultEvent(this.getId(), name, data);
        this.sendLocal(event);
        this.sendRemote(event);
    }

    void sendRemote(Event event) {
        for (DefaultEventBusClient client : this.clients) {
            client.sendRemote(event);
        }
    }

    @Override
    public String toString() {
        return EventBusServer.class.getSimpleName() + ":" + this.getId();
    }

    private Collection<DefaultEventBusClient> getClients() {
        this.clientsLock.readLock().lock();
        try {
            ArrayList<DefaultEventBusClient> arrayList = new ArrayList<DefaultEventBusClient>(this.clients);
            return arrayList;
        }
        finally {
            this.clientsLock.readLock().unlock();
        }
    }
}

