/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ipceventbus.event;

import java.util.UUID;
import org.terracotta.ipceventbus.event.DefaultEventBus;
import org.terracotta.ipceventbus.event.ErrorListener;
import org.terracotta.ipceventbus.event.EventBus;
import org.terracotta.ipceventbus.event.EventBusException;
import org.terracotta.ipceventbus.event.EventListener;
import org.terracotta.ipceventbus.event.Listeners;
import org.terracotta.ipceventbus.event.RethrowingErrorListener;

public class BaseBuilder<T extends BaseBuilder<T>> {
    String busId;
    ErrorListener errorListener = new RethrowingErrorListener();
    Listeners listeners = new Listeners();

    BaseBuilder() {
    }

    public T id(String busId) {
        this.busId = busId;
        return (T)this;
    }

    public T on(String event, EventListener listener) {
        this.listeners.on(event).add(listener);
        return (T)this;
    }

    public T on(EventListener listener) {
        this.listeners.on("").add(listener);
        return (T)this;
    }

    public T onError(ErrorListener listener) {
        this.errorListener = listener;
        return (T)this;
    }

    public EventBus build() throws EventBusException {
        return new DefaultEventBus(this.busId != null ? this.busId : UUID.randomUUID().toString(), this.errorListener, this.listeners);
    }
}

