/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ipceventbus.event;

import java.io.Serializable;
import org.terracotta.ipceventbus.event.Assert;
import org.terracotta.ipceventbus.event.Event;

class DefaultEvent
implements Serializable,
Event {
    private static final long serialVersionUID = -4856946361193249489L;
    private final String source;
    private final String name;
    private final long timestamp = System.currentTimeMillis();
    private final Object data;

    DefaultEvent(String source, String name) {
        this(source, name, null);
    }

    DefaultEvent(String source, String name, Object data) {
        Assert.legalEventName(name);
        this.source = source;
        this.name = name;
        this.data = data;
    }

    @Override
    public boolean isUserEvent() {
        return !this.name.startsWith("eventbus.");
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public <T> T getData(Class<T> type) {
        return type.cast(this.getData());
    }

    @Override
    public <T> T getData(Class<T> type, T defaultValue) {
        T t = this.getData(type);
        return t == null ? defaultValue : t;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Event{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", source=").append(this.source);
        sb.append(", data=").append(this.data);
        sb.append('}');
        return sb.toString();
    }
}

