/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ipceventbus.event;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.SocketFactory;
import org.terracotta.ipceventbus.event.BaseBuilder;
import org.terracotta.ipceventbus.event.DefaultEventBusClient;
import org.terracotta.ipceventbus.event.EventBusException;
import org.terracotta.ipceventbus.event.EventBusIOException;
import org.terracotta.ipceventbus.event.PrintingErrorListener;
import org.terracotta.ipceventbus.event.RemoteEventBus;

public interface EventBusClient
extends RemoteEventBus {
    @Override
    public String getServerHost();

    public static final class Builder
    extends BaseBuilder<Builder> {
        InetSocketAddress endpoint;

        public Builder() {
            this.errorListener = new PrintingErrorListener();
        }

        public Builder connect(String host, int port) {
            this.endpoint = new InetSocketAddress(host, port);
            return this;
        }

        public Builder connect(int port) {
            return this.connect("localhost", port);
        }

        @Override
        public EventBusClient build() throws EventBusException {
            if (this.endpoint == null) {
                this.connect(System.getProperty("ipc.bus.host", "localhost"), Integer.parseInt(System.getProperty("ipc.bus.port", "56789")));
            }
            try {
                Socket socket = SocketFactory.getDefault().createSocket();
                socket.connect(this.endpoint);
                return this.busId == null ? new DefaultEventBusClient(socket, this.errorListener, this.listeners) : new DefaultEventBusClient(this.busId, socket, this.errorListener, this.listeners);
            }
            catch (IOException e) {
                throw new EventBusIOException("Bad endpoint: " + this.endpoint.getHostName() + ":" + this.endpoint.getPort() + " : " + e.getMessage(), e);
            }
        }
    }
}

