/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ipceventbus.event;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.terracotta.ipceventbus.event.EventListener;

final class Listeners {
    private final ConcurrentMap<String, Collection<EventListener>> index;

    Listeners(Listeners original) {
        this.index = new ConcurrentHashMap<String, CopyOnWriteArrayList>(original.index.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new CopyOnWriteArrayList((Collection)e.getValue()))));
    }

    Listeners() {
        this.index = new ConcurrentHashMap<String, Collection<EventListener>>();
    }

    public Collection<EventListener> on(String event) {
        this.index.putIfAbsent(event, new CopyOnWriteArrayList());
        return (Collection)this.index.get(event);
    }

    public void removeAll(String event) {
        this.index.remove(event);
    }

    public void removeAll(EventListener listener) {
        for (Collection listeners : this.index.values()) {
            listeners.remove(listener);
        }
    }

    public void remove(String event, EventListener listener) {
        Collection listeners = (Collection)this.index.get(event);
        if (listeners != null) {
            listeners.remove(listener);
        }
    }
}

