/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ipceventbus.proc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.terracotta.ipceventbus.proc.AnyProcess;

public class AnyProcessBuilder<T extends AnyProcess> {
    File workingDir = new File(".");
    InputStream pipeStdin;
    OutputStream pipeStdout;
    OutputStream pipeStderr;
    boolean redirectStderr;
    Map<String, String> env = new LinkedHashMap<String, String>(System.getenv());
    boolean recordStdout;
    boolean recordStderr;
    List<String> command = new ArrayList<String>();
    boolean debug;

    public AnyProcessBuilder<T> debug() {
        this.debug = true;
        return this;
    }

    public final AnyProcessBuilder<T> command(String ... command) {
        this.command = new ArrayList<String>(Arrays.asList(command));
        return this;
    }

    public final AnyProcessBuilder<T> pipeStdin(InputStream pipeStdin) {
        this.pipeStdin = pipeStdin;
        return this;
    }

    public final AnyProcessBuilder<T> pipeStdin() {
        return this.pipeStdin(System.in);
    }

    public final AnyProcessBuilder<T> pipeStdout(OutputStream pipeStdout) {
        this.pipeStdout = pipeStdout;
        return this;
    }

    public final AnyProcessBuilder<T> pipeStdout() {
        return this.pipeStdout(System.out);
    }

    public final AnyProcessBuilder<T> pipeStderr(OutputStream pipeStderr) {
        this.pipeStderr = pipeStderr;
        return this;
    }

    public final AnyProcessBuilder<T> pipeStderr() {
        return this.pipeStderr(System.err);
    }

    public final AnyProcessBuilder<T> workingDir(File workingDirectory) {
        this.workingDir = workingDirectory;
        return this;
    }

    public final AnyProcessBuilder<T> redirectStderr() {
        this.redirectStderr = true;
        return this;
    }

    public final AnyProcessBuilder<T> env(Map<String, String> newEnv) {
        this.env = new LinkedHashMap<String, String>(newEnv);
        return this;
    }

    public final AnyProcessBuilder<T> env(String key, String value) {
        this.env.put(key, value);
        return this;
    }

    public final AnyProcessBuilder<T> recordStdout() {
        this.recordStdout = true;
        return this;
    }

    public final AnyProcessBuilder<T> recordStderr() {
        this.recordStderr = true;
        return this;
    }

    public T build() {
        return (T)new AnyProcess(this.createProcess(), this.pipeStdout, this.pipeStderr, this.pipeStdin, this.recordStdout, this.recordStderr, this.command, this.workingDir);
    }

    protected Process createProcess() {
        if (this.command.isEmpty()) {
            throw new IllegalArgumentException("Missing command");
        }
        ProcessBuilder builder = new ProcessBuilder(new String[0]).command(this.command).directory(this.workingDir).redirectErrorStream(this.redirectStderr);
        Map<String, String> processEnv = builder.environment();
        processEnv.clear();
        processEnv.putAll(this.env);
        try {
            Process process = builder.start();
            if (this.debug) {
                System.out.println("[" + AnyProcess.getCurrentPid() + "] Started process " + AnyProcess.getPid(process) + ": " + String.join((CharSequence)" ", builder.command()));
            }
            return process;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to start " + this.command, e);
        }
    }
}

