/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ipceventbus.proc;

import java.lang.management.ManagementFactory;
import org.terracotta.ipceventbus.event.EventBusClient;
import org.terracotta.ipceventbus.event.EventListenerSniffer;
import org.terracotta.ipceventbus.proc.Boot;

public final class Bus {
    private static final EventBusClient bus;

    public static EventBusClient get() {
        return bus;
    }

    public static boolean isDebug() {
        return System.getProperty("ipc.bus.debug") != null;
    }

    static String getCurrentPid() {
        try {
            return ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
        }
        catch (Exception ignored) {
            return null;
        }
    }

    static {
        String host = System.getProperty("ipc.bus.host");
        int port = Integer.parseInt(System.getProperty("ipc.bus.port"));
        String pid = Bus.getCurrentPid();
        if (Bus.isDebug()) {
            System.out.println("[" + Boot.class.getSimpleName() + "] Child PID: " + pid);
            System.out.println("[" + Boot.class.getSimpleName() + "] Connecting EventBus Client " + pid + " to " + host + ":" + port + "...");
        }
        bus = ((EventBusClient.Builder)new EventBusClient.Builder().connect(host, port).id(pid)).build();
        if (Bus.isDebug()) {
            bus.on(new EventListenerSniffer(pid));
        }
    }
}

