/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ipceventbus.proc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.terracotta.ipceventbus.event.EventBusClient;
import org.terracotta.ipceventbus.event.EventBusServer;
import org.terracotta.ipceventbus.event.EventListener;
import org.terracotta.ipceventbus.event.EventListenerSniffer;
import org.terracotta.ipceventbus.proc.EventJavaProcessBuilder;
import org.terracotta.ipceventbus.proc.JavaProcess;

public final class EventJavaProcess
extends JavaProcess {
    private volatile EventBusServer eventBus;

    public EventJavaProcess(Process process, OutputStream pipeStdout, OutputStream pipeStderr, InputStream pipeStdin, boolean collectStdout, boolean collectStderr, List<String> command, File workingDir, File javaHome, File javaExecutable, List<String> jvmArgs, List<File> classpath, String mainClass, List<String> arguments, Map<String, String> jvmProperties, boolean debug, EventBusServer eventBusServer) {
        super(process, pipeStdout, pipeStderr, pipeStdin, collectStdout, collectStderr, command, workingDir, javaHome, javaExecutable, jvmArgs, classpath, mainClass, arguments, jvmProperties);
        String pid = EventJavaProcess.getCurrentPid();
        this.eventBus = eventBusServer;
        if (debug) {
            this.eventBus.on(new EventListenerSniffer(pid));
        }
    }

    @Override
    protected void onDestroyed() {
        if (this.eventBus != null) {
            this.eventBus.trigger("process.destroyed");
        }
        this.close();
    }

    @Override
    protected void onTerminated() {
        if (this.eventBus != null) {
            this.eventBus.trigger("process.exited");
        }
        this.close();
    }

    private void close() {
        try {
            if (this.eventBus != null && this.eventBus instanceof EventBusClient && !((EventBusClient)((Object)this.eventBus)).isClosed()) {
                ((EventBusClient)((Object)this.eventBus)).close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final boolean isEventBusConnected() {
        return this.eventBus.getClientCount() > 0;
    }

    public final String getEventBusServerHost() {
        return this.eventBus.getServerHost();
    }

    public final int getEventBusServerPort() {
        return this.eventBus.getServerPort();
    }

    public final String getEventBusId() {
        return this.eventBus.getId();
    }

    public final void on(String event, EventListener listener) {
        this.eventBus.on(event, listener);
    }

    public final void unbind(String event) {
        this.eventBus.unbind(event);
    }

    public final void on(EventListener listener) {
        this.eventBus.on(listener);
    }

    public final void unbind(EventListener listener) {
        this.eventBus.unbind(listener);
    }

    public final void unbind(String event, EventListener listener) {
        this.eventBus.unbind(event, listener);
    }

    public final void trigger(String name) {
        this.eventBus.trigger(name);
    }

    public final void trigger(String name, Object data) {
        this.eventBus.trigger(name, data);
    }

    public static EventJavaProcessBuilder<? extends EventJavaProcess> newBuilder() {
        return new EventJavaProcessBuilder();
    }
}

