/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ipceventbus.proc;

import org.terracotta.ipceventbus.event.EventBusServer;
import org.terracotta.ipceventbus.event.EventListener;
import org.terracotta.ipceventbus.proc.Boot;
import org.terracotta.ipceventbus.proc.Bus;
import org.terracotta.ipceventbus.proc.EventJavaProcess;
import org.terracotta.ipceventbus.proc.JavaProcessBuilder;

public class EventJavaProcessBuilder<T extends EventJavaProcess>
extends JavaProcessBuilder<T> {
    final EventBusServer.Builder eventBusBuilder = new EventBusServer.Builder();

    public EventJavaProcessBuilder<T> port(int port) {
        this.eventBusBuilder.listen(port);
        return this;
    }

    public EventJavaProcessBuilder<T> randomPort() {
        this.eventBusBuilder.listenRandom();
        return this;
    }

    public EventJavaProcessBuilder<T> on(String event, EventListener listener) {
        this.eventBusBuilder.on(event, listener);
        return this;
    }

    public EventJavaProcessBuilder<T> on(EventListener listener) {
        this.eventBusBuilder.on(listener);
        return this;
    }

    @Override
    public T build() {
        EventBusServer eventBusServer = this.eventBusBuilder.build();
        this.addJvmProp("ipc.bus.host", "localhost");
        this.addJvmProp("ipc.bus.port", Integer.toString(eventBusServer.getServerPort()));
        this.addClasspath(Bus.class);
        if (this.debug) {
            this.addJvmProp("ipc.bus.debug", "true");
        }
        if (this.mainClass != null) {
            this.addJvmProp("ipc.bus.mainClass", this.mainClass);
            this.mainClass(Boot.class.getName());
        }
        this.buildCommand();
        return (T)new EventJavaProcess(this.createProcess(), this.pipeStdout, this.pipeStderr, this.pipeStdin, this.recordStdout, this.recordStderr, this.command, this.workingDir, this.javaHome, this.javaExecutable, this.jvmArgs, this.classpath, this.mainClass, this.arguments, this.jvmProps, this.debug, eventBusServer);
    }
}

