/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ipceventbus.proc;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.terracotta.ipceventbus.proc.AnyProcess;
import org.terracotta.ipceventbus.proc.AnyProcessBuilder;
import org.terracotta.ipceventbus.proc.JavaProcess;

public class JavaProcessBuilder<T extends JavaProcess>
extends AnyProcessBuilder<T> {
    String mainClass;
    File javaHome = new File(System.getProperty("java.home"));
    File javaExecutable = JavaProcessBuilder.findJavaExecutable(this.javaHome);
    List<String> jvmArgs = new ArrayList<String>();
    List<File> classpath = new ArrayList<File>();
    List<String> arguments = new ArrayList<String>();
    Map<String, String> jvmProps = new LinkedHashMap<String, String>();

    public final JavaProcessBuilder<T> mainClass(String mainClass) {
        this.mainClass = mainClass;
        return this;
    }

    public final JavaProcessBuilder<T> mainClass(Class<?> mainClass) {
        this.mainClass(mainClass.getName());
        return this.addClasspath(mainClass);
    }

    public final JavaProcessBuilder<T> javaHome(File javaHome) {
        this.javaHome = javaHome;
        return this;
    }

    public final JavaProcessBuilder<T> javaExecutable(File javaExecutable) {
        this.javaExecutable = javaExecutable;
        return this;
    }

    public final JavaProcessBuilder<T> jvmArgs(List<String> jvmArgs) {
        this.jvmArgs = jvmArgs;
        return this;
    }

    public final JavaProcessBuilder<T> addJvmArg(String arg) {
        this.jvmArgs.add(arg);
        return this;
    }

    public final JavaProcessBuilder<T> jvmProps(Map<String, String> jvmProps) {
        this.jvmProps = new LinkedHashMap<String, String>(jvmProps);
        return this;
    }

    public final JavaProcessBuilder<T> addJvmProp(String key, String val) {
        this.jvmProps.put(key, val);
        return this;
    }

    public final JavaProcessBuilder<T> classpath(List<File> classpath) {
        this.classpath = classpath;
        return this;
    }

    public final JavaProcessBuilder<T> addClasspath(URL location) {
        try {
            return this.addClasspath(new File(location.toURI()));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(location.toString());
        }
    }

    public final JavaProcessBuilder<T> addClasspath(File location) {
        if (!this.classpath.contains(location)) {
            this.classpath.add(location);
        }
        return this;
    }

    public final JavaProcessBuilder<T> addClasspath(Class<?> enclosingJar) {
        return this.addClasspath(enclosingJar.getProtectionDomain().getCodeSource().getLocation());
    }

    public final JavaProcessBuilder<T> arguments(List<String> args) {
        this.arguments = args;
        return this;
    }

    public final JavaProcessBuilder<T> arguments(String ... args) {
        this.arguments = Arrays.asList(args);
        return this;
    }

    public final JavaProcessBuilder<T> addArgument(String arg) {
        this.arguments.add(arg);
        return this;
    }

    protected void buildCommand() {
        if (this.mainClass == null) {
            throw new IllegalArgumentException("Missing main class");
        }
        if (this.javaHome == null || !this.javaHome.isDirectory()) {
            throw new IllegalArgumentException("Bad JAVA_HOME: " + this.javaHome);
        }
        if (this.javaExecutable == null || !this.javaExecutable.isFile()) {
            throw new IllegalArgumentException("Bad Java executable: " + this.javaExecutable);
        }
        this.command.add(this.javaExecutable.getAbsolutePath());
        this.command.addAll(this.jvmArgs);
        if (!this.classpath.isEmpty()) {
            for (File file : this.classpath) {
                if (file.exists()) continue;
                throw new IllegalArgumentException("Classpath entry does not exist: " + file);
            }
            this.command.add("-classpath");
            StringBuilder cp = new StringBuilder(this.classpath.get(0).getAbsolutePath());
            String string = AnyProcess.isWindows() ? ";" : ":";
            for (int i = 1; i < this.classpath.size(); ++i) {
                cp.append(string).append(this.classpath.get(i));
            }
            this.command.add(cp.toString());
        }
        for (Map.Entry entry : this.jvmProps.entrySet()) {
            this.command.add("-D" + (String)entry.getKey() + "=" + (String)entry.getValue());
        }
        this.command.add(this.mainClass);
        this.command.addAll(this.arguments);
    }

    @Override
    public T build() {
        this.buildCommand();
        return (T)new JavaProcess(this.createProcess(), this.pipeStdout, this.pipeStderr, this.pipeStdin, this.recordStdout, this.recordStderr, this.command, this.workingDir, this.javaHome, this.javaExecutable, this.jvmArgs, this.classpath, this.mainClass, this.arguments, this.jvmProps);
    }

    private static File findJavaExecutable(File javaHome) {
        File javaBin = new File(javaHome, "bin");
        File javaPlain = new File(javaBin, "java");
        File javaExe = new File(javaBin, "java.exe");
        if (javaPlain.isFile()) {
            return javaPlain;
        }
        if (javaExe.isFile()) {
            return javaExe;
        }
        return null;
    }
}

