/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.capabilities.context;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.terracotta.management.Objects;

public final class CapabilityContext
implements Serializable {
    private final Collection<Attribute> attributes;

    public CapabilityContext(Attribute ... attributes) {
        this(Arrays.asList(attributes));
    }

    public CapabilityContext(Collection<Attribute> attributes) {
        this.attributes = Objects.requireNonNull(attributes);
    }

    public Collection<Attribute> getAttributes() {
        return this.attributes;
    }

    public Collection<String> getRequiredAttributeNames() {
        HashSet<String> names = new HashSet<String>();
        for (Attribute attribute : this.attributes) {
            if (!attribute.isRequired()) continue;
            names.add(attribute.getName());
        }
        return names;
    }

    public Collection<Attribute> getRequiredAttributes() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(this.attributes.size());
        for (Attribute attribute : this.attributes) {
            if (!attribute.isRequired()) continue;
            attributes.add(attribute);
        }
        return attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CapabilityContext that = (CapabilityContext)o;
        return ((Object)this.attributes).equals(that.attributes);
    }

    public int hashCode() {
        return ((Object)this.attributes).hashCode();
    }

    public static final class Attribute
    implements Serializable {
        private final String name;
        private final boolean required;

        public Attribute(String name, boolean required) {
            this.name = Objects.requireNonNull(name);
            this.required = required;
        }

        public String getName() {
            return this.name;
        }

        public boolean isRequired() {
            return this.required;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Attribute attribute = (Attribute)o;
            if (this.required != attribute.required) {
                return false;
            }
            return this.name.equals(attribute.name);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.required ? 1 : 0);
            return result;
        }
    }
}

