/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.message;

import java.io.Serializable;
import java.util.Arrays;
import org.terracotta.management.Objects;
import org.terracotta.management.call.ContextualReturn;
import org.terracotta.management.message.Message;
import org.terracotta.management.message.MessageType;
import org.terracotta.management.notification.ContextualNotification;
import org.terracotta.management.stats.ContextualStatistics;

public final class DefaultMessage
implements Serializable,
Message {
    private final Object data;
    private final long timeMillis;
    private final String messageType;

    private DefaultMessage(long timeMillis, String messageType, Object data) {
        this.timeMillis = timeMillis;
        this.messageType = Objects.requireNonNull(messageType);
        this.data = Objects.requireNonNull(data);
    }

    public DefaultMessage(long timeMillis, ContextualNotification notification) {
        this(timeMillis, MessageType.NOTIFICATION.name(), notification);
    }

    public DefaultMessage(long timeMillis, ContextualReturn<?> response) {
        this(timeMillis, MessageType.RETURN.name(), response);
    }

    public DefaultMessage(long timeMillis, ContextualStatistics ... statistics) {
        this(timeMillis, MessageType.STATISTICS.name(), (Object)statistics);
    }

    @Override
    public <T> T unwrap(Class<T> type) {
        return type.cast(this.data);
    }

    @Override
    public long getTimeMillis() {
        return this.timeMillis;
    }

    @Override
    public String getType() {
        return this.messageType;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "timeMillis=" + this.getTimeMillis() + ", type=" + this.getType() + ", data=" + (this.data == null ? null : (this.data.getClass().isArray() ? Arrays.toString((Object[])this.data) : this.data)) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultMessage that = (DefaultMessage)o;
        if (this.timeMillis != that.timeMillis) {
            return false;
        }
        if (this.data.getClass() != that.data.getClass()) {
            return false;
        }
        if (this.data.getClass().isArray() ? !Arrays.equals((Object[])this.data, (Object[])that.data) : !this.data.equals(that.data)) {
            return false;
        }
        return this.messageType.equals(that.messageType);
    }

    public int hashCode() {
        int result = this.data.getClass().isArray() ? Arrays.hashCode((Object[])this.data) : this.data.hashCode();
        result = 31 * result + (int)(this.timeMillis ^ this.timeMillis >>> 32);
        result = 31 * result + this.messageType.hashCode();
        return result;
    }
}

