/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.stats;

import java.io.Serializable;
import org.terracotta.management.Objects;
import org.terracotta.management.stats.Statistic;

public abstract class AbstractStatistic<V extends Serializable, U extends Serializable>
implements Statistic<V, U>,
Serializable {
    private final V value;
    private final U unit;

    public AbstractStatistic(V value, U unit) {
        this.value = (Serializable)Objects.requireNonNull(value);
        this.unit = (Serializable)Objects.requireNonNull(unit);
    }

    @Override
    public final U getUnit() {
        return this.unit;
    }

    @Override
    public final V getValue() {
        return this.value;
    }

    public String toString() {
        return "{type='" + this.getClass().getSimpleName() + '\'' + ", value=" + this.getValue() + ", unit=" + this.getUnit() + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractStatistic that = (AbstractStatistic)o;
        if (!this.value.equals(that.value)) {
            return false;
        }
        return this.unit.equals(that.unit);
    }

    public int hashCode() {
        int result = this.value.hashCode();
        result = 31 * result + this.unit.hashCode();
        return result;
    }
}

