/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.stats;

import java.io.Serializable;

public final class Sample<V extends Serializable>
implements Serializable {
    private final long timestamp;
    private final V value;

    public Sample(long timestamp, V value) {
        this.timestamp = timestamp;
        this.value = value;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public V getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sample sample = (Sample)o;
        if (this.timestamp != sample.timestamp) {
            return false;
        }
        return this.value != null ? this.value.equals(sample.value) : sample.value == null;
    }

    public int hashCode() {
        int result = (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "{timestamp=" + this.timestamp + ", value=" + this.value + '}';
    }
}

