/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.terracotta.management.capabilities.Capability;
import org.terracotta.management.registry.CapabilityManagement;
import org.terracotta.management.registry.DefaultCapabilityManagement;
import org.terracotta.management.registry.ManagementProvider;
import org.terracotta.management.registry.ManagementRegistry;

public abstract class AbstractManagementRegistry
implements ManagementRegistry {
    protected final List<ManagementProvider<?>> managementProviders = new CopyOnWriteArrayList();

    @Override
    public final void addManagementProvider(ManagementProvider<?> provider) {
        String name = provider.getCapabilityName();
        for (ManagementProvider<?> managementProvider : this.managementProviders) {
            if (!managementProvider.getCapabilityName().equals(name)) continue;
            throw new IllegalStateException("Duplicated management provider name : " + name);
        }
        this.managementProviders.add(provider);
    }

    @Override
    public final void removeManagementProvider(ManagementProvider<?> provider) {
        this.managementProviders.remove(provider);
    }

    @Override
    public final void register(Object managedObject) {
        for (ManagementProvider<?> managementProvider : this.managementProviders) {
            if (!managementProvider.getManagedType().isInstance(managedObject)) continue;
            managementProvider.register(managedObject);
        }
    }

    @Override
    public final void unregister(Object managedObject) {
        for (ManagementProvider<?> managementProvider : this.managementProviders) {
            if (!managementProvider.getManagedType().isInstance(managedObject)) continue;
            managementProvider.unregister(managedObject);
        }
    }

    @Override
    public final CapabilityManagement withCapability(String capabilityName) {
        return new DefaultCapabilityManagement(this, capabilityName);
    }

    @Override
    public final Collection<Capability> getCapabilities() {
        ArrayList<Capability> capabilities = new ArrayList<Capability>();
        for (ManagementProvider<?> managementProvider : this.managementProviders) {
            capabilities.add(managementProvider.getCapability());
        }
        return capabilities;
    }

    public final List<ManagementProvider<?>> getManagementProvidersByCapability(String capabilityName) {
        ArrayList allProviders = new ArrayList();
        for (ManagementProvider<?> provider : this.managementProviders) {
            if (!provider.getCapabilityName().equals(capabilityName)) continue;
            allProviders.add(provider);
        }
        return allProviders;
    }
}

