/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.model.call;

import java.io.Serializable;
import java.util.NoSuchElementException;
import org.terracotta.management.model.Objects;
import org.terracotta.management.model.context.Context;

public final class ContextualReturn<T extends Serializable>
implements Serializable {
    private final T value;
    private final Context context;
    private final String capability;
    private final String methodName;

    private ContextualReturn(String capability, Context context, String methodName, T value) {
        this.methodName = methodName;
        this.value = value;
        this.context = Objects.requireNonNull(context);
        this.capability = Objects.requireNonNull(capability);
    }

    public boolean hasValue() {
        return this.value != Void.TYPE;
    }

    public T getValue() throws NoSuchElementException {
        if (!this.hasValue()) {
            throw new NoSuchElementException();
        }
        return this.value;
    }

    public Context getContext() {
        return this.context;
    }

    public static <T extends Serializable> ContextualReturn<T> of(String capability, Context context, String methodName, T result) {
        return new ContextualReturn<T>(capability, context, methodName, result);
    }

    public static <T extends Serializable> ContextualReturn<T> empty(String capability, Context context, String methodName) {
        return new ContextualReturn<Class<Void>>(capability, context, methodName, Void.TYPE);
    }

    public String getCapability() {
        return this.capability;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String toString() {
        return "ContextualReturn{capability='" + this.capability + '\'' + "method='" + this.methodName + '\'' + ", context=" + this.context + ", value=" + this.value + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextualReturn that = (ContextualReturn)o;
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        if (!this.context.equals(that.context)) {
            return false;
        }
        if (!this.methodName.equals(that.methodName)) {
            return false;
        }
        return this.capability.equals(that.capability);
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + this.context.hashCode();
        result = 31 * result + this.methodName.hashCode();
        result = 31 * result + this.capability.hashCode();
        return result;
    }
}

