/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.model.context;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class Context
extends AbstractMap<String, String>
implements Serializable {
    private final Map<String, String> back = new LinkedHashMap<String, String>();

    private Context(Map<String, String> back) {
        this.back.putAll(back);
    }

    public Map<String, String> toMap() {
        return Collections.unmodifiableMap(this.back);
    }

    public Context with(String key, String val) {
        if (val == null) {
            throw new NullPointerException();
        }
        Context context = new Context(this.back);
        context.back.put(key, val);
        return context;
    }

    public Context with(Map<String, String> props) {
        for (String val : props.values()) {
            if (val != null) continue;
            throw new NullPointerException();
        }
        Context context = new Context(this.back);
        context.back.putAll(props);
        return context;
    }

    public String get(String key) {
        return this.back.get(key);
    }

    @Override
    public int size() {
        return this.back.size();
    }

    @Override
    public boolean isEmpty() {
        return this.back.isEmpty();
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.toMap().entrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Context context = (Context)o;
        return ((Object)this.back).equals(context.back);
    }

    @Override
    public int hashCode() {
        return ((Object)this.back).hashCode();
    }

    @Override
    public String toString() {
        return this.back.toString();
    }

    public boolean contains(Context subCtx) {
        return this.back.entrySet().containsAll(subCtx.back.entrySet());
    }

    public boolean contains(String key) {
        return this.back.containsKey(key);
    }

    public boolean contains(String key, String val) {
        return this.back.containsKey(key) && this.back.get(key).equals(val);
    }

    public static Context create(String key, String val) {
        return Context.empty().with(key, val);
    }

    public static Context create(Map<String, String> map) {
        return new Context(map);
    }

    public static Context empty() {
        return new Context(Collections.<String, String>emptyMap());
    }
}

