/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.model.context;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.terracotta.management.model.Objects;

public final class ContextContainer
implements Serializable {
    private final String name;
    private final String value;
    private final Collection<ContextContainer> subContexts;

    public ContextContainer(String name, String value) {
        this(name, value, Collections.emptyList());
    }

    public ContextContainer(String name, String value, ContextContainer ... subContexts) {
        this(name, value, Arrays.asList(subContexts));
    }

    public ContextContainer(String name, String value, Collection<ContextContainer> subContexts) {
        this.name = Objects.requireNonNull(name);
        this.value = Objects.requireNonNull(value);
        this.subContexts = Objects.requireNonNull(subContexts);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public Collection<ContextContainer> getSubContexts() {
        return this.subContexts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextContainer that = (ContextContainer)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.value.equals(that.value)) {
            return false;
        }
        return ((Object)this.subContexts).equals(that.subContexts);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.value.hashCode();
        result = 31 * result + ((Object)this.subContexts).hashCode();
        return result;
    }
}

