/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.model.stats;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.terracotta.management.model.Objects;
import org.terracotta.management.model.stats.Sample;
import org.terracotta.management.model.stats.StatisticHistory;

public abstract class AbstractStatisticHistory<V extends Serializable, U extends Serializable>
implements StatisticHistory<V, U>,
Serializable {
    private final Sample<V>[] values;
    private final U unit;

    public AbstractStatisticHistory(List<Sample<V>> values, U unit) {
        this.values = Objects.requireNonNull(values).toArray(new Sample[values.size()]);
        this.unit = (Serializable)Objects.requireNonNull(unit);
    }

    public AbstractStatisticHistory(U unit, Sample<V> ... values) {
        this.values = Objects.requireNonNull(values);
        this.unit = (Serializable)Objects.requireNonNull(unit);
    }

    @Override
    public final U getUnit() {
        return this.unit;
    }

    @Override
    public final Sample<V>[] getValue() {
        return this.values;
    }

    public String toString() {
        return "{type='" + this.getClass().getSimpleName() + '\'' + ", value=" + Arrays.toString(this.values) + ", unit=" + this.getUnit() + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractStatisticHistory that = (AbstractStatisticHistory)o;
        if (!Arrays.equals(this.values, that.values)) {
            return false;
        }
        return this.unit.equals(that.unit);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.values);
        result = 31 * result + this.unit.hashCode();
        return result;
    }
}

