/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.model.stats;

public enum MemoryUnit {
    B{

        @Override
        public long toBytes(long size) {
            return size;
        }
    }
    ,
    KB{

        @Override
        public long toBytes(long size) {
            return 2.x(size, 1024L, 0x1FFFFFFFFFFFFFL);
        }
    }
    ,
    MB{

        @Override
        public long toBytes(long size) {
            return 3.x(size, 0x100000L, 0x7FFFFFFFFFFL);
        }
    }
    ,
    GB{

        @Override
        public long toBytes(long size) {
            return 4.x(size, 0x40000000L, 0x1FFFFFFFFL);
        }
    }
    ,
    TB{

        @Override
        public long toBytes(long size) {
            return 5.x(size, 0x10000000000L, 0x7FFFFFL);
        }
    }
    ,
    PB{

        @Override
        public long toBytes(long size) {
            return 6.x(size, 0x4000000000000L, 8191L);
        }
    };

    static final long BYTE = 1L;
    static final long KILOBYTE = 1024L;
    static final long MEGABYTE = 0x100000L;
    static final long GIGABYTE = 0x40000000L;
    static final long TERABYTE = 0x10000000000L;
    static final long PETABYTE = 0x4000000000000L;
    static final long MAX = Long.MAX_VALUE;

    static long x(long d, long m, long over) {
        if (d > over) {
            return Long.MAX_VALUE;
        }
        if (d < -over) {
            return Long.MIN_VALUE;
        }
        return d * m;
    }

    public long toBytes(long size) {
        throw new AbstractMethodError();
    }
}

